/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rockdb.manager;

import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rockdb.model.Entry;
import io.nuls.core.rockdb.util.DBUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.Options;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.Transaction;
import org.rocksdb.TransactionDB;
import org.rocksdb.TransactionDBOptions;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class TransactionDBManager {
    private static final ConcurrentHashMap<String, TransactionDB> TABLES;
    private static final String BASE_DB_NAME = "rocksdb";
    private static volatile boolean isInit;
    private static ReentrantLock lock;
    private static String dataPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String path) throws Exception {
        Class<TransactionDBManager> clazz = TransactionDBManager.class;
        synchronized (TransactionDBManager.class) {
            isInit = true;
            File dir = DBUtils.loadDataPath(path);
            dataPath = dir.getPath();
            Log.info((String)("TransactionDBManager dataPath is " + dataPath));
            File[] tableFiles = dir.listFiles();
            String dbPath = null;
            for (File tableFile : tableFiles) {
                if (!tableFile.isDirectory() || TABLES.get(tableFile.getName()) != null) continue;
                try {
                    dbPath = tableFile.getPath() + File.separator + BASE_DB_NAME;
                    TransactionDB db = TransactionDBManager.initOpenDB(dbPath);
                    if (db == null) continue;
                    TABLES.put(tableFile.getName(), db);
                }
                catch (Exception e) {
                    Log.warn((String)("load table failed, tableName: " + tableFile.getName() + ", dbPath: " + dbPath), (Throwable)e);
                    throw e;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static TransactionDB initOpenDB(String dbPath) throws RocksDBException {
        File checkFile = new File(dbPath + File.separator + "CURRENT");
        if (!checkFile.exists()) {
            return null;
        }
        Options options = TransactionDBManager.getCommonOptions(false);
        return TransactionDB.open((Options)options, (TransactionDBOptions)new TransactionDBOptions(), (String)dbPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createTable(String tableName) throws Exception {
        lock.lock();
        try {
            if (StringUtils.isBlank((String)tableName)) {
                throw new Exception("Parameter can not be null");
            }
            if (TABLES.containsKey(tableName)) {
                throw new Exception("DB table exists");
            }
            if (StringUtils.isBlank((String)dataPath) || !DBUtils.checkPathLegal(tableName)) {
                throw new Exception("Create DB table path error");
            }
            try {
                File dir = new File(dataPath + File.separator + tableName);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                String filePath = dataPath + File.separator + tableName + File.separator + BASE_DB_NAME;
                Options options = TransactionDBManager.getCommonOptions(true);
                TransactionDB db = TransactionDB.open((Options)options, (TransactionDBOptions)new TransactionDBOptions(), (String)filePath);
                TABLES.put(tableName, db);
            }
            catch (Exception e) {
                Log.error((String)("error create table: " + tableName), (Throwable)e);
                throw new Exception("Create DB table error");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public static TransactionDB getTable(String tableName) {
        return TABLES.get(tableName);
    }

    public static boolean destroyTable(String tableName) throws Exception {
        if (StringUtils.isBlank((String)dataPath) || !DBUtils.checkPathLegal(tableName)) {
            throw new Exception("Create DB table path error");
        }
        if (!TransactionDBManager.baseCheckTable(tableName)) {
            throw new Exception("DB table not exists");
        }
        try {
            TransactionDB db = TABLES.remove(tableName);
            db.close();
            File dir = new File(dataPath + File.separator + tableName);
            if (!dir.exists()) {
                throw new Exception("DB table not exists");
            }
            String filePath = dataPath + File.separator + tableName + File.separator + BASE_DB_NAME;
            TransactionDBManager.destroyDB(filePath);
        }
        catch (Exception e) {
            Log.error((String)("error destroy table: " + tableName), (Throwable)e);
            throw new Exception("Destroy DB table error");
        }
        return true;
    }

    private static void destroyDB(String dbPath) throws RocksDBException {
        Options options = new Options();
        TransactionDB.destroyDB((String)dbPath, (Options)options);
    }

    public static String[] listTable() {
        int i = 0;
        Enumeration<String> keys = TABLES.keys();
        String[] tables = new String[TABLES.size()];
        int length = tables.length;
        while (keys.hasMoreElements()) {
            tables[i++] = keys.nextElement();
            if (i != length) continue;
            break;
        }
        return tables;
    }

    public static void close() {
        Set<Map.Entry<String, TransactionDB>> entries = TABLES.entrySet();
        for (Map.Entry<String, TransactionDB> entry : entries) {
            try {
                TABLES.remove(entry.getKey());
                entry.getValue().close();
            }
            catch (Exception e) {
                Log.warn((String)"close rocksdb error", (Throwable)e);
            }
        }
    }

    public static boolean put(String table, byte[] key, byte[] value) throws Exception {
        if (!TransactionDBManager.baseCheckTable(table)) {
            throw new Exception("DB table not exists");
        }
        if (key == null || value == null) {
            throw new Exception("Parameter can not be null");
        }
        try {
            TransactionDB db = TABLES.get(table);
            db.put(key, value);
            return true;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw new Exception("DB error");
        }
    }

    public static boolean batchPut(String table, Map<byte[], byte[]> kvs) throws Exception {
        boolean bl;
        if (!TransactionDBManager.baseCheckTable(table)) {
            throw new Exception("DB table not exists");
        }
        if (kvs == null || kvs.size() == 0) {
            throw new Exception("Parameter can not be null");
        }
        WriteBatch writeBatch = new WriteBatch();
        try {
            TransactionDB db = TABLES.get(table);
            for (Map.Entry<byte[], byte[]> entry : kvs.entrySet()) {
                writeBatch.put(entry.getKey(), entry.getValue());
            }
            db.write(new WriteOptions(), writeBatch);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writeBatch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                Log.error((Throwable)ex);
                throw new Exception("DB error");
            }
        }
        writeBatch.close();
        return bl;
    }

    public static boolean delete(String table, byte[] key) throws Exception {
        if (!TransactionDBManager.baseCheckTable(table)) {
            throw new Exception("DB table not exists");
        }
        if (key == null) {
            throw new Exception("Parameter can not be null");
        }
        try {
            TransactionDB db = TABLES.get(table);
            db.delete(key);
            return true;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            throw new Exception("DB error");
        }
    }

    public static boolean deleteKeys(String table, List<byte[]> keys) throws Exception {
        boolean bl;
        if (!TransactionDBManager.baseCheckTable(table)) {
            throw new Exception("DB table not exists");
        }
        if (keys == null || keys.size() == 0) {
            throw new Exception("Parameter can not be null");
        }
        WriteBatch writeBatch = new WriteBatch();
        try {
            TransactionDB db = TABLES.get(table);
            for (byte[] key : keys) {
                writeBatch.delete(key);
            }
            db.write(new WriteOptions(), writeBatch);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writeBatch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                Log.error((Throwable)ex);
                throw new Exception("DB error");
            }
        }
        writeBatch.close();
        return bl;
    }

    public static byte[] get(String table, byte[] key) {
        if (!TransactionDBManager.baseCheckTable(table)) {
            return null;
        }
        if (key == null) {
            return null;
        }
        try {
            TransactionDB db = TABLES.get(table);
            return db.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<byte[], byte[]> multiGet(String table, List<byte[]> keys) {
        if (!TransactionDBManager.baseCheckTable(table)) {
            return null;
        }
        if (keys == null || keys.size() == 0) {
            return null;
        }
        try {
            TransactionDB db = TABLES.get(table);
            return db.multiGet(keys);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<byte[]> multiGetValueList(String table, List<byte[]> keys) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        if (!TransactionDBManager.baseCheckTable(table)) {
            return list;
        }
        if (keys == null || keys.size() == 0) {
            return list;
        }
        try {
            TransactionDB db = TABLES.get(table);
            Map map = db.multiGet(keys);
            if (map != null && map.size() > 0) {
                list.addAll(map.values());
            }
            return list;
        }
        catch (Exception ex) {
            return list;
        }
    }

    public static List<byte[]> multiGetKeyList(String table, List<byte[]> keys) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        if (!TransactionDBManager.baseCheckTable(table)) {
            return list;
        }
        if (keys == null || keys.size() == 0) {
            return list;
        }
        try {
            TransactionDB db = TABLES.get(table);
            Map map = db.multiGet(keys);
            if (map != null && map.size() > 0) {
                list.addAll(map.keySet());
            }
            return list;
        }
        catch (Exception ex) {
            return list;
        }
    }

    public static List<byte[]> keyList(String table) {
        if (!TransactionDBManager.baseCheckTable(table)) {
            return null;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        try {
            TransactionDB db = TABLES.get(table);
            try (RocksIterator iterator = db.newIterator();){
                iterator.seekToFirst();
                while (iterator.isValid()) {
                    list.add(iterator.key());
                    iterator.next();
                }
            }
            return list;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<byte[]> valueList(String table) {
        if (!TransactionDBManager.baseCheckTable(table)) {
            return null;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        try {
            TransactionDB db = TABLES.get(table);
            try (RocksIterator iterator = db.newIterator();){
                iterator.seekToFirst();
                while (iterator.isValid()) {
                    list.add(iterator.value());
                    iterator.next();
                }
            }
            return list;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<Entry<byte[], byte[]>> entryList(String table) {
        if (!TransactionDBManager.baseCheckTable(table)) {
            return null;
        }
        ArrayList<Entry<byte[], byte[]>> entryList = new ArrayList<Entry<byte[], byte[]>>();
        try {
            TransactionDB db = TABLES.get(table);
            try (RocksIterator iterator = db.newIterator();){
                iterator.seekToFirst();
                while (iterator.isValid()) {
                    entryList.add(new Entry<byte[], byte[]>(iterator.key(), iterator.value()));
                    iterator.next();
                }
            }
            return entryList;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Transaction openSession(String table) {
        WriteOptions options = new WriteOptions();
        TransactionDB db = TABLES.get(table);
        return db.beginTransaction(options);
    }

    public static void commit(Transaction tx) throws RocksDBException {
        try {
            tx.commit();
        }
        finally {
            tx.close();
        }
    }

    public static void rollBack(Transaction tx) throws RocksDBException {
        try {
            tx.rollback();
        }
        finally {
            tx.close();
        }
    }

    private static boolean baseCheckTable(String tableName) {
        return !StringUtils.isBlank((String)tableName) && TABLES.containsKey(tableName);
    }

    private static synchronized Options getCommonOptions(boolean createIfMissing) {
        Options options = new Options();
        options.setCreateIfMissing(createIfMissing);
        options.setAllowMmapReads(true);
        options.setCompressionType(CompressionType.NO_COMPRESSION);
        options.setMaxOpenFiles(-1);
        BlockBasedTableConfig tableOption = new BlockBasedTableConfig();
        tableOption.setNoBlockCache(true);
        tableOption.setBlockRestartInterval(4);
        tableOption.setFilterPolicy((Filter)new BloomFilter(10, true));
        options.setTableFormatConfig((TableFormatConfig)tableOption);
        return options;
    }

    static {
        TransactionDB.loadLibrary();
        TABLES = new ConcurrentHashMap();
        isInit = false;
        lock = new ReentrantLock();
    }
}

