/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;

public class RPCUtil {
    public static String encode(byte[] src) {
        return src == null ? null : HexUtil.encode((byte[])src);
    }

    public static byte[] decode(String src) {
        return src == null ? null : HexUtil.decode((String)src);
    }

    public static <T> T getInstance(byte[] bytes, Class<? extends BaseNulsData> clazz) {
        if (null == bytes || bytes.length == 0) {
            Log.error((String)("error code-" + CommonCodeConstanst.DESERIALIZE_ERROR));
            return null;
        }
        try {
            BaseNulsData baseNulsData = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            baseNulsData.parse(new NulsByteBuffer(bytes));
            return (T)baseNulsData;
        }
        catch (Exception e) {
            Log.error((String)("error code-" + CommonCodeConstanst.DESERIALIZE_ERROR));
            return null;
        }
    }

    public static <T> T getInstanceRpcStr(String data, Class<? extends BaseNulsData> clazz) {
        if (StringUtils.isBlank((String)data)) {
            Log.error((String)("error code-" + CommonCodeConstanst.DESERIALIZE_ERROR));
            return null;
        }
        return RPCUtil.getInstance(RPCUtil.decode(data), clazz);
    }
}

