/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.basic;

import com.google.common.base.Objects;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import java.io.IOException;
import java.util.Comparator;

public class ProtocolVersion
extends BaseNulsData {
    public static final Comparator<ProtocolVersion> COMPARATOR = Comparator.comparingInt(ProtocolVersion::getVersion);
    private short version;
    private byte effectiveRatio;
    private short continuousIntervalCount;

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public byte getEffectiveRatio() {
        return this.effectiveRatio;
    }

    public void setEffectiveRatio(byte effectiveRatio) {
        this.effectiveRatio = effectiveRatio;
    }

    public short getContinuousIntervalCount() {
        return this.continuousIntervalCount;
    }

    public void setContinuousIntervalCount(short continuousIntervalCount) {
        this.continuousIntervalCount = continuousIntervalCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolVersion that = (ProtocolVersion)o;
        return this.version == that.version && this.effectiveRatio == that.effectiveRatio && this.continuousIntervalCount == that.continuousIntervalCount;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.version, this.effectiveRatio, this.continuousIntervalCount});
    }

    public int size() {
        return 5;
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeShort(this.version);
        stream.writeByte(this.effectiveRatio);
        stream.writeShort(this.continuousIntervalCount);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.version = byteBuffer.readShort();
        this.effectiveRatio = byteBuffer.readByte();
        this.continuousIntervalCount = byteBuffer.readShort();
    }

    public String toString() {
        return "{version=" + this.version + ", effectiveRatio=" + this.effectiveRatio + ", continuousIntervalCount=" + this.continuousIntervalCount + "}";
    }
}

