/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.basic;

import io.nuls.core.exception.NulsRuntimeException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TransactionFeeCalculator {
    public static final BigInteger CROSSTX_PRICE_PRE_1024_BYTES = BigInteger.valueOf(1000000L);
    public static final int KB = 1024;

    public static final BigInteger getNormalTxFee(int size, long feeUnit) {
        BigInteger NORMAL_PRICE_PRE_1024_BYTES = BigInteger.valueOf(feeUnit);
        BigInteger fee = NORMAL_PRICE_PRE_1024_BYTES.multiply(new BigInteger(String.valueOf(size / 1024)));
        if (size % 1024 > 0) {
            fee = fee.add(NORMAL_PRICE_PRE_1024_BYTES);
        }
        return fee;
    }

    public static final BigInteger getConsensusTxFee(int size, long unit) {
        BigInteger unitBigInteger = BigInteger.valueOf(unit);
        BigInteger fee = unitBigInteger.multiply(new BigInteger(String.valueOf(size / 1024)));
        if (size % 1024 > 0) {
            fee = fee.add(unitBigInteger);
        }
        return fee;
    }

    public static final BigInteger getNormalUnsignedTxFee(int size, long feeUnit, double feeCoefficient) {
        BigInteger NORMAL_PRICE_PRE_1024_BYTES = BigInteger.valueOf(feeUnit);
        BigInteger fee = NORMAL_PRICE_PRE_1024_BYTES.multiply(new BigInteger(String.valueOf((size += 110) / 1024)));
        if (size % 1024 > 0) {
            fee = fee.add(NORMAL_PRICE_PRE_1024_BYTES);
        }
        if (1.0 != feeCoefficient) {
            BigDecimal deci = BigDecimal.valueOf(feeCoefficient);
            fee = deci.multiply(new BigDecimal(fee)).toBigInteger();
        }
        return fee;
    }

    public static final BigInteger getCrossTxFee(int size) {
        BigInteger fee = CROSSTX_PRICE_PRE_1024_BYTES.multiply(new BigInteger(String.valueOf(size / 1024)));
        if (size % 1024 > 0) {
            fee = fee.add(CROSSTX_PRICE_PRE_1024_BYTES);
        }
        return fee;
    }

    public static final BigInteger getFee(int size, BigInteger price, long feeUnit) {
        BigInteger NORMAL_PRICE_PRE_1024_BYTES = BigInteger.valueOf(feeUnit);
        if (price.compareTo(NORMAL_PRICE_PRE_1024_BYTES) < 0) {
            throw new NulsRuntimeException((Throwable)new Exception("entity is error"));
        }
        if (price.compareTo(CROSSTX_PRICE_PRE_1024_BYTES) > 0) {
            throw new NulsRuntimeException((Throwable)new Exception("entity is error"));
        }
        BigInteger fee = price.multiply(new BigInteger(String.valueOf(size / 1024)));
        if (size % 1024 > 0) {
            fee = fee.add(price);
        }
        return fee;
    }
}

