/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.model.StringUtils;

public class Address {
    public static final int ADDRESS_LENGTH = 23;
    public static final int RIPEMD160_LENGTH = 20;
    private String prefix;
    private int chainId;
    private String addressStr;
    private byte addressType;
    protected byte[] hash160;
    protected byte[] addressBytes;

    public Address(String address) {
        try {
            byte[] bytes = AddressTool.getAddress(address);
            Address addressTmp = Address.fromHashs(bytes);
            this.chainId = addressTmp.getChainId();
            this.addressType = addressTmp.getAddressType();
            this.hash160 = addressTmp.getHash160();
            this.addressBytes = this.calcAddressbytes();
            this.prefix = AddressTool.getPrefix(address);
        }
        catch (Exception e) {
            Log.error((Throwable)e);
        }
    }

    public Address(int chainId, byte addressType, byte[] hash160) {
        this.chainId = chainId;
        this.addressType = addressType;
        this.hash160 = hash160;
        this.addressBytes = this.calcAddressbytes();
        this.prefix = AddressTool.getPrefix(chainId);
    }

    public Address(int chainId, String prefix, byte addressType, byte[] hash160) {
        this.chainId = chainId;
        this.addressType = addressType;
        this.hash160 = hash160;
        this.addressBytes = this.calcAddressbytes();
        this.prefix = prefix;
    }

    public byte[] getHash160() {
        return this.hash160;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getChainId() {
        return this.chainId;
    }

    public static Address fromHashs(String address) {
        byte[] bytes = AddressTool.getAddress(address);
        return Address.fromHashs(bytes);
    }

    public static Address fromHashs(byte[] hashs) {
        int chainId;
        if (hashs == null || hashs.length != 23) {
            throw new NulsRuntimeException((Throwable)new Exception());
        }
        NulsByteBuffer byteBuffer = new NulsByteBuffer(hashs);
        try {
            chainId = byteBuffer.readUint16();
        }
        catch (NulsException e) {
            Log.error((Throwable)e);
            throw new NulsRuntimeException((Throwable)e);
        }
        byte addressType = hashs[2];
        byte[] content = new byte[20];
        System.arraycopy(hashs, 3, content, 0, 20);
        return new Address(chainId, addressType, content);
    }

    private byte[] calcAddressbytes() {
        byte[] body = new byte[23];
        System.arraycopy(ByteUtils.shortToBytes((short)((short)this.chainId)), 0, body, 0, 2);
        body[2] = this.addressType;
        System.arraycopy(this.hash160, 0, body, 3, this.hash160.length);
        return body;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Address) {
            Address other = (Address)obj;
            return ByteUtils.arrayEquals((byte[])this.addressBytes, (byte[])other.getAddressBytes());
        }
        return false;
    }

    public byte[] getAddressBytes() {
        return this.addressBytes;
    }

    public void setAddressBytes(byte[] addressBytes) {
        this.addressBytes = addressBytes;
    }

    public byte getAddressType() {
        return this.addressType;
    }

    public void setAddressType(byte addressType) {
        this.addressType = addressType;
    }

    public static int size() {
        return 23;
    }

    public String toString() {
        return this.getBase58();
    }

    public String getBase58() {
        if (StringUtils.isNotBlank((String)this.prefix)) {
            this.addressStr = AddressTool.getStringAddressByBytes(this.addressBytes, this.prefix);
        } else if (StringUtils.isBlank((String)this.addressStr)) {
            this.addressStr = AddressTool.getStringAddressByBytes(this.addressBytes);
        }
        return this.addressStr;
    }
}

