/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.CoinFrom;
import io.nuls.base.data.CoinTo;
import io.nuls.core.basic.NulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteArrayWrapper;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CoinData
extends BaseNulsData {
    private List<CoinFrom> from = new ArrayList<CoinFrom>();
    private List<CoinTo> to = new ArrayList<CoinTo>();

    public CoinData() {
    }

    public CoinData(byte[] bytes) throws NulsException {
        this.parse(new NulsByteBuffer(bytes));
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        int fromCount = this.from == null ? 0 : this.from.size();
        stream.writeVarInt(fromCount);
        if (null != this.from) {
            for (CoinFrom coin : this.from) {
                stream.writeNulsData(coin);
            }
        }
        int toCount = this.to == null ? 0 : this.to.size();
        stream.writeVarInt(toCount);
        if (null != this.to) {
            for (CoinTo coin : this.to) {
                stream.writeNulsData(coin);
            }
        }
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        int toCount;
        int fromCount = (int)byteBuffer.readVarInt();
        if (0 < fromCount) {
            ArrayList<CoinFrom> from = new ArrayList<CoinFrom>();
            for (int i = 0; i < fromCount; ++i) {
                from.add(byteBuffer.readNulsData(new CoinFrom()));
            }
            this.from = from;
        }
        if (0 < (toCount = (int)byteBuffer.readVarInt())) {
            ArrayList<CoinTo> to = new ArrayList<CoinTo>();
            for (int i = 0; i < toCount; ++i) {
                to.add(byteBuffer.readNulsData(new CoinTo()));
            }
            this.to = to;
        }
    }

    public int size() {
        int size = SerializeUtils.sizeOfVarInt((Integer)(this.from == null ? 0 : this.from.size()));
        if (null != this.from) {
            for (CoinFrom coinFrom : this.from) {
                size += SerializeUtils.sizeOfNulsData((NulsData)coinFrom);
            }
        }
        size += SerializeUtils.sizeOfVarInt((Integer)(this.to == null ? 0 : this.to.size()));
        if (null != this.to) {
            for (CoinTo coinTo : this.to) {
                size += SerializeUtils.sizeOfNulsData((NulsData)coinTo);
            }
        }
        return size;
    }

    public List<CoinFrom> getFrom() {
        return this.from;
    }

    public void setFrom(List<CoinFrom> from) {
        this.from = from;
    }

    public List<CoinTo> getTo() {
        return this.to;
    }

    public void setTo(List<CoinTo> to) {
        this.to = to;
    }

    public void addTo(CoinTo coinTo) {
        if (null == this.to) {
            this.to = new ArrayList<CoinTo>();
        }
        this.to.add(coinTo);
    }

    public void addFrom(CoinFrom coinFrom) {
        if (null == this.from) {
            this.from = new ArrayList<CoinFrom>();
        }
        this.from.add(coinFrom);
    }

    @JsonIgnore
    public Set<byte[]> getAddresses() {
        ByteArrayWrapper baw;
        byte[] address;
        HashSet<ByteArrayWrapper> addressSetWrapper = new HashSet<ByteArrayWrapper>();
        if (this.to != null && this.to.size() != 0) {
            for (CoinTo coinTo : this.to) {
                address = coinTo.getAddress();
                baw = new ByteArrayWrapper(address);
                addressSetWrapper.add(baw);
            }
        }
        if (this.from != null && this.from.size() != 0) {
            for (CoinFrom coinFrom : this.from) {
                address = coinFrom.getAddress();
                baw = new ByteArrayWrapper(address);
                addressSetWrapper.add(baw);
            }
        }
        HashSet<byte[]> addressSet = new HashSet<byte[]>();
        for (ByteArrayWrapper byteArrayWrapper : addressSetWrapper) {
            addressSet.add(byteArrayWrapper.getBytes());
        }
        return addressSet;
    }

    public Set<String> getFromAddressList() {
        HashSet<String> fromAddressList = new HashSet<String>();
        if (this.from != null && !this.from.isEmpty()) {
            for (CoinFrom coinFrom : this.from) {
                fromAddressList.add(AddressTool.getStringAddressByBytes(coinFrom.getAddress()));
            }
        }
        return fromAddressList;
    }

    public int getFromAddressCount() {
        HashSet<String> addressSet = new HashSet<String>();
        for (CoinFrom coinFrom : this.from) {
            addressSet.add(AddressTool.getStringAddressByBytes(coinFrom.getAddress()));
        }
        return addressSet.size();
    }

    public BigInteger getFeeByAsset(int assetChainId, int assetId) {
        BigInteger fromAmount = BigInteger.ZERO;
        BigInteger toAmount = BigInteger.ZERO;
        for (CoinFrom coinFrom : this.from) {
            if (coinFrom.getAssetsChainId() != assetChainId || coinFrom.getAssetsId() != assetId) continue;
            fromAmount = fromAmount.add(coinFrom.getAmount());
        }
        for (CoinTo coinTo : this.to) {
            if (coinTo.getAssetsChainId() != assetChainId || coinTo.getAssetsId() != assetId) continue;
            toAmount = toAmount.add(coinTo.getAmount());
        }
        return fromAmount.subtract(toAmount);
    }
}

