/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.data;

import com.google.common.base.Objects;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.Address;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiSigAccount
extends BaseNulsData {
    private int chainId;
    private Address address;
    private byte m;
    private List<byte[]> pubKeyList;
    private String alias;

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint32(this.chainId);
        stream.write(this.address.getAddressBytes());
        stream.write(this.m);
        stream.writeUint32(this.pubKeyList.size());
        for (int i = 0; i < this.pubKeyList.size(); ++i) {
            stream.writeBytesWithLength(this.pubKeyList.get(i));
        }
        stream.writeString(this.alias);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readInt32();
        byte[] bytes = byteBuffer.readBytes(23);
        this.address = Address.fromHashs(bytes);
        this.m = byteBuffer.readByte();
        this.pubKeyList = new ArrayList<byte[]>();
        long count = byteBuffer.readUint32();
        int i = 0;
        while ((long)i < count) {
            this.pubKeyList.add(byteBuffer.readByLengthByte());
            ++i;
        }
        this.alias = byteBuffer.readString();
    }

    public int size() {
        int size = SerializeUtils.sizeOfUint32();
        size += 23;
        ++size;
        size += SerializeUtils.sizeOfUint32();
        for (int i = 0; i < this.pubKeyList.size(); ++i) {
            size += SerializeUtils.sizeOfBytes((byte[])this.pubKeyList.get(i));
        }
        return size += SerializeUtils.sizeOfString((String)this.alias);
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public List<byte[]> getPubKeyList() {
        return this.pubKeyList;
    }

    public void setPubKeyList(List<byte[]> pubKeyList) {
        this.pubKeyList = pubKeyList;
    }

    public byte getM() {
        return this.m;
    }

    public void setM(byte m) {
        this.m = m;
    }

    public void addPubkeys(List<String> pubkeys) {
        this.pubKeyList = new ArrayList<byte[]>();
        for (String pubkeyStr : pubkeys) {
            this.pubKeyList.add(HexUtil.decode((String)pubkeyStr));
        }
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiSigAccount that = (MultiSigAccount)o;
        return this.chainId == that.chainId && this.m == that.m && Objects.equal((Object)this.address, (Object)that.address) && Objects.equal(this.pubKeyList, that.pubKeyList) && Objects.equal((Object)this.alias, (Object)that.alias);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.chainId, this.address, this.m, this.pubKeyList, this.alias});
    }
}

