/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.script;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedBytes;
import io.nuls.base.script.Script;
import io.nuls.base.script.ScriptChunk;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;

public class ScriptBuilder {
    private List<ScriptChunk> chunks;
    public static final Comparator<String> PUBKEY_COMPARATOR = new Comparator<String>(){
        private Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

        @Override
        public int compare(String k1, String k2) {
            return this.comparator.compare(HexUtil.decode((String)k1), HexUtil.decode((String)k2));
        }
    };
    public static final Comparator<byte[]> PUBKEY_BYTE_COMPARATOR = new Comparator<byte[]>(){
        private Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

        @Override
        public int compare(byte[] k1, byte[] k2) {
            return this.comparator.compare(k1, k2);
        }
    };

    public ScriptBuilder() {
        this.chunks = Lists.newLinkedList();
    }

    public ScriptBuilder(Script template) {
        this.chunks = new ArrayList<ScriptChunk>(template.getChunks());
    }

    public ScriptBuilder addChunk(ScriptChunk chunk) {
        return this.addChunk(this.chunks.size(), chunk);
    }

    public ScriptBuilder addChunk(int index, ScriptChunk chunk) {
        this.chunks.add(index, chunk);
        return this;
    }

    public ScriptBuilder op(int opcode) {
        return this.op(this.chunks.size(), opcode);
    }

    public ScriptBuilder op(int index, int opcode) {
        Preconditions.checkArgument((opcode > 78 ? 1 : 0) != 0);
        return this.addChunk(index, new ScriptChunk(opcode, null));
    }

    public ScriptBuilder data(byte[] data) {
        if (data.length == 0) {
            return this.smallNum(0);
        }
        return this.data(this.chunks.size(), data);
    }

    public ScriptBuilder data(int index, byte[] data) {
        int opcode;
        byte[] copy = Arrays.copyOf(data, data.length);
        if (data.length == 0) {
            opcode = 0;
        } else if (data.length == 1) {
            byte b = data[0];
            opcode = b >= 1 && b <= 16 ? Script.encodeToOpN(b) : 1;
        } else if (data.length < 76) {
            opcode = data.length;
        } else if (data.length < 256) {
            opcode = 76;
        } else if (data.length < 65536) {
            opcode = 77;
        } else {
            throw new RuntimeException("Unimplemented");
        }
        return this.addChunk(index, new ScriptChunk(opcode, copy));
    }

    public ScriptBuilder number(long num) {
        return this.number(this.chunks.size(), num);
    }

    public ScriptBuilder number(int index, long num) {
        if (num == -1L) {
            return this.op(index, 79);
        }
        if (num >= 0L && num <= 16L) {
            return this.addChunk(index, new ScriptChunk(Script.encodeToOpN((int)num), null));
        }
        return this.bigNum(index, num);
    }

    public ScriptBuilder smallNum(int num) {
        return this.smallNum(this.chunks.size(), num);
    }

    protected ScriptBuilder bigNum(long num) {
        return this.bigNum(this.chunks.size(), num);
    }

    public ScriptBuilder smallNum(int index, int num) {
        Preconditions.checkArgument((num >= 0 ? 1 : 0) != 0, (Object)"Cannot encode negative numbers with smallNum");
        Preconditions.checkArgument((num <= 16 ? 1 : 0) != 0, (Object)"Cannot encode numbers larger than 16 with smallNum");
        return this.addChunk(index, new ScriptChunk(Script.encodeToOpN(num), null));
    }

    protected ScriptBuilder bigNum(int index, long num) {
        byte[] data;
        if (num == 0L) {
            data = new byte[]{};
        } else {
            Stack<Byte> result = new Stack<Byte>();
            boolean neg = num < 0L;
            for (long absvalue = Math.abs(num); absvalue != 0L; absvalue >>= 8) {
                result.push((byte)(absvalue & 0xFFL));
            }
            if (((Byte)result.peek() & 0x80) != 0) {
                result.push((byte)(neg ? 128 : 0));
            } else if (neg) {
                result.push((byte)((Byte)result.pop() | 0x80));
            }
            data = new byte[result.size()];
            for (int byteIdx = 0; byteIdx < data.length; ++byteIdx) {
                data[byteIdx] = (Byte)result.get(byteIdx);
            }
        }
        return this.addChunk(index, new ScriptChunk(data.length, data));
    }

    public Script build() {
        return new Script(this.chunks);
    }

    public static Script createOutputScript(byte[] address, int type) {
        if (type == 0) {
            return new ScriptBuilder().op(169).data(address).op(135).build();
        }
        return new ScriptBuilder().op(118).op(169).data(address).op(136).op(172).build();
    }

    public static Script createOutputScript(ECKey key) {
        return new ScriptBuilder().data(key.getPubKey()).op(172).build();
    }

    public static Script createInputScript(@Nullable TransactionSignature signature, ECKey pubKey) {
        byte[] pubkeyBytes = pubKey.getPubKey();
        byte[] sigBytes = null;
        return new ScriptBuilder().data(sigBytes).data(pubkeyBytes).build();
    }

    public static Script createNulsInputScript(@Nullable byte[] signBytes, byte[] pubKeyBytes) {
        return new ScriptBuilder().data(signBytes).data(pubKeyBytes).build();
    }

    public static Script createInputScript(@Nullable TransactionSignature signature) {
        byte[] sigBytes = null;
        return new ScriptBuilder().data(sigBytes).build();
    }

    public static Script createMultiSigOutputScript(int threshold, List<ECKey> pubkeys) {
        Preconditions.checkArgument((threshold > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((threshold <= pubkeys.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((pubkeys.size() <= 16 ? 1 : 0) != 0);
        ScriptBuilder builder = new ScriptBuilder();
        builder.smallNum(threshold);
        for (ECKey key : pubkeys) {
            builder.data(key.getPubKey());
        }
        builder.smallNum(pubkeys.size());
        builder.op(174);
        return builder.build();
    }

    public static Script createNulsMultiSigOutputScript(int threshold, List<String> pubkeys) {
        Preconditions.checkArgument((threshold > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((threshold <= pubkeys.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((pubkeys.size() <= 16 ? 1 : 0) != 0);
        ScriptBuilder builder = new ScriptBuilder();
        builder.smallNum(threshold);
        for (String pubKey : pubkeys) {
            builder.data(HexUtil.decode((String)pubKey));
        }
        builder.smallNum(pubkeys.size());
        builder.op(174);
        return builder.build();
    }

    public static Script createByteNulsMultiSigOutputScript(int threshold, List<byte[]> pubkeys) {
        Preconditions.checkArgument((threshold > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((threshold <= pubkeys.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((pubkeys.size() <= 16 ? 1 : 0) != 0);
        ScriptBuilder builder = new ScriptBuilder();
        builder.smallNum(threshold);
        for (byte[] pubkey : pubkeys) {
            builder.data(pubkey);
        }
        builder.smallNum(pubkeys.size());
        builder.op(174);
        return builder.build();
    }

    public static Script createMultiSigInputScript(List<TransactionSignature> signatures) {
        ArrayList<byte[]> sigs = new ArrayList<byte[]>(signatures.size());
        for (TransactionSignature transactionSignature : signatures) {
        }
        return ScriptBuilder.createMultiSigInputScriptBytes(sigs, null);
    }

    public static Script createMultiSigInputScript(TransactionSignature ... signatures) {
        return ScriptBuilder.createMultiSigInputScript(Arrays.asList(signatures));
    }

    public static Script createMultiSigInputScriptBytes(List<byte[]> signatures) {
        return ScriptBuilder.createMultiSigInputScriptBytes(signatures, null);
    }

    public static Script createP2SHMultiSigInputScript(@Nullable List<TransactionSignature> signatures, Script multisigProgram) {
        ArrayList<byte[]> sigs = new ArrayList<byte[]>();
        if (signatures == null) {
            int numSigs = multisigProgram.getNumberOfSignaturesRequiredToSpend();
            for (int i = 0; i < numSigs; ++i) {
                sigs.add(new byte[0]);
            }
        } else {
            for (TransactionSignature transactionSignature : signatures) {
            }
        }
        return ScriptBuilder.createMultiSigInputScriptBytes(sigs, multisigProgram.getProgram());
    }

    public static Script createNulsP2SHMultiSigInputScript(@Nullable List<byte[]> signatures, Script multisigProgram) {
        ArrayList<byte[]> sigs = new ArrayList<byte[]>();
        if (signatures == null) {
            int numSigs = multisigProgram.getNumberOfSignaturesRequiredToSpend();
            for (int i = 0; i < numSigs; ++i) {
                sigs.add(new byte[0]);
            }
        } else {
            for (byte[] signature : signatures) {
                sigs.add(signature);
            }
        }
        return ScriptBuilder.createMultiSigInputScriptBytes(sigs, multisigProgram.getProgram());
    }

    public static Script createMultiSigInputScriptBytes(List<byte[]> signatures, @Nullable byte[] multisigProgramBytes) {
        Preconditions.checkArgument((signatures.size() <= 16 ? 1 : 0) != 0);
        ScriptBuilder builder = new ScriptBuilder();
        builder.smallNum(0);
        for (byte[] signature : signatures) {
            builder.data(signature);
        }
        if (multisigProgramBytes != null) {
            builder.data(multisigProgramBytes);
        }
        return builder.build();
    }

    public static Script updateScriptWithSignature(Script scriptSig, byte[] signature, int targetIndex, int sigsPrefixCount, int sigsSuffixCount) {
        ScriptBuilder builder = new ScriptBuilder();
        List<ScriptChunk> inputChunks = scriptSig.getChunks();
        int totalChunks = inputChunks.size();
        boolean hasMissingSigs = inputChunks.get(totalChunks - sigsSuffixCount - 1).equalsOpCode(0);
        Preconditions.checkArgument((boolean)hasMissingSigs, (Object)"ScriptSig is already filled with signatures");
        for (ScriptChunk chunk : inputChunks.subList(0, sigsPrefixCount)) {
            builder.addChunk(chunk);
        }
        int pos = 0;
        boolean inserted = false;
        for (ScriptChunk chunk : inputChunks.subList(sigsPrefixCount, totalChunks - sigsSuffixCount)) {
            if (pos == targetIndex) {
                inserted = true;
                builder.data(signature);
                ++pos;
            }
            if (chunk.equalsOpCode(0)) continue;
            builder.addChunk(chunk);
            ++pos;
        }
        while (pos < totalChunks - sigsPrefixCount - sigsSuffixCount) {
            if (pos == targetIndex) {
                inserted = true;
                builder.data(signature);
            } else {
                builder.addChunk(new ScriptChunk(0, null));
            }
            ++pos;
        }
        for (ScriptChunk chunk : inputChunks.subList(totalChunks - sigsSuffixCount, totalChunks)) {
            builder.addChunk(chunk);
        }
        Preconditions.checkState((boolean)inserted);
        return builder.build();
    }

    public static Script createP2SHOutputScript(byte[] hash) {
        Preconditions.checkArgument((hash.length == 23 ? 1 : 0) != 0);
        return new ScriptBuilder().op(169).data(hash).op(135).build();
    }

    public static Script createRedeemScript(int threshold, List<ECKey> pubkeys) {
        pubkeys = new ArrayList<ECKey>(pubkeys);
        Collections.sort(pubkeys, ECKey.PUBKEY_COMPARATOR);
        return ScriptBuilder.createMultiSigOutputScript(threshold, pubkeys);
    }

    public static Script createNulsRedeemScript(int threshold, List<String> pubkeys) {
        pubkeys = new ArrayList<String>(pubkeys);
        Collections.sort(pubkeys, PUBKEY_COMPARATOR);
        return ScriptBuilder.createNulsMultiSigOutputScript(threshold, pubkeys);
    }

    public static Script createByteNulsRedeemScript(int threshold, List<byte[]> pubkeys) {
        pubkeys = new ArrayList<byte[]>(pubkeys);
        Collections.sort(pubkeys, PUBKEY_BYTE_COMPARATOR);
        return ScriptBuilder.createByteNulsMultiSigOutputScript(threshold, pubkeys);
    }

    public static Script createOpReturnScript(byte[] data) {
        Preconditions.checkArgument((data.length <= 80 ? 1 : 0) != 0);
        return new ScriptBuilder().op(106).data(data).build();
    }
}

