/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.signture;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.NulsSignData;
import io.nuls.core.basic.NulsData;
import io.nuls.core.basic.Result;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class BlockSignature
extends BaseNulsData {
    private NulsSignData signData;
    private byte[] publicKey;

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.publicKey.length);
        stream.write(this.publicKey);
        stream.writeNulsData(this.signData);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        byte length = byteBuffer.readByte();
        this.publicKey = byteBuffer.readBytes(length);
        this.signData = new NulsSignData();
        this.signData.parse(byteBuffer);
    }

    public int size() {
        int size = 1 + this.publicKey.length;
        return size += SerializeUtils.sizeOfNulsData((NulsData)this.signData);
    }

    public Result verifySignature(NulsHash digestData) {
        boolean b = ECKey.verify((byte[])digestData.getBytes(), (byte[])this.signData.getSignBytes(), (byte[])this.publicKey);
        if (b) {
            return new Result(true);
        }
        return new Result(false);
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public NulsSignData getSignData() {
        return this.signData;
    }

    public void setSignData(NulsSignData signData) {
        this.signData = signData;
    }
}

