/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.signture;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.ByteUtils;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultiSignTxSignature
extends TransactionSignature {
    private byte m;
    private List<byte[]> pubKeyList;

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.m);
        stream.writeVarInt(this.pubKeyList.size());
        for (byte[] bytes : this.pubKeyList) {
            stream.writeBytesWithLength(bytes);
        }
        super.serializeToStream(stream);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.m = byteBuffer.readByte();
        long count = byteBuffer.readVarInt();
        if (0L < count) {
            ArrayList<byte[]> pubKeyList = new ArrayList<byte[]>();
            int i = 0;
            while ((long)i < count) {
                pubKeyList.add(byteBuffer.readByLengthByte());
                ++i;
            }
            this.pubKeyList = pubKeyList;
        }
        super.parse(byteBuffer);
    }

    @Override
    public int size() {
        boolean isPubKeyListNotNull;
        int size = 0;
        ++size;
        boolean bl = isPubKeyListNotNull = this.pubKeyList != null;
        if (isPubKeyListNotNull) {
            size += SerializeUtils.sizeOfVarInt((Integer)this.pubKeyList.size());
            for (byte[] bytes : this.pubKeyList) {
                size += SerializeUtils.sizeOfBytes((byte[])bytes);
            }
        }
        return size += super.size();
    }

    public void addPubkey(byte[] pubkey) {
        if (null == this.pubKeyList) {
            this.pubKeyList = new ArrayList<byte[]>();
        }
        this.pubKeyList.add(pubkey);
    }

    public List<P2PHKSignature> getValidSignature() {
        if (this.m <= 0 || this.pubKeyList == null || this.pubKeyList.size() == 0 || this.m > this.pubKeyList.size()) {
            return null;
        }
        ArrayList<P2PHKSignature> validSignatures = new ArrayList<P2PHKSignature>();
        List pubKeyStrList = ByteUtils.bytesToStrings(this.pubKeyList);
        for (P2PHKSignature p2PHKSignature : this.p2PHKSignatures) {
            if (!pubKeyStrList.contains(ByteUtils.asString((byte[])p2PHKSignature.getPublicKey()))) continue;
            validSignatures.add(p2PHKSignature);
        }
        if (validSignatures.size() < this.m || validSignatures.size() > this.pubKeyList.size()) {
            return null;
        }
        return validSignatures;
    }

    public byte getM() {
        return this.m;
    }

    public void setM(byte m) {
        this.m = m;
    }

    public List<byte[]> getPubKeyList() {
        return this.pubKeyList;
    }

    public void setPubKeyList(List<byte[]> pubKeyList) {
        this.pubKeyList = pubKeyList;
    }
}

