/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.signture;

import com.google.common.primitives.UnsignedBytes;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.base.data.NulsHash;
import io.nuls.base.data.NulsSignData;
import io.nuls.core.basic.NulsData;
import io.nuls.core.basic.Result;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class P2PHKSignature
extends BaseNulsData {
    public static final int SERIALIZE_LENGTH = 110;
    private NulsSignData signData;
    private byte[] publicKey;
    public static final Comparator<P2PHKSignature> PUBKEY_COMPARATOR = new Comparator<P2PHKSignature>(){
        private Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

        @Override
        public int compare(P2PHKSignature k1, P2PHKSignature k2) {
            return this.comparator.compare(k1.getPublicKey(), k2.getPublicKey());
        }
    };

    public P2PHKSignature() {
    }

    public P2PHKSignature(byte[] signBytes, byte[] publicKey) {
        this.signData = new NulsSignData();
        try {
            this.signData.parse(signBytes, 0);
        }
        catch (NulsException e) {
            Log.error((Throwable)e);
        }
        this.publicKey = publicKey;
    }

    public P2PHKSignature(NulsSignData signData, byte[] publicKey) {
        this.signData = signData;
        this.publicKey = publicKey;
    }

    public NulsSignData getSignData() {
        return this.signData;
    }

    public void setSignData(NulsSignData signData) {
        this.signData = signData;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public Result verifySign(NulsHash digestData) {
        boolean b = ECKey.verify((byte[])digestData.getBytes(), (byte[])this.signData.getSignBytes(), (byte[])this.getPublicKey());
        if (b) {
            return new Result(true);
        }
        return new Result(false);
    }

    public byte[] getSignerHash160() {
        return SerializeUtils.sha256hash160((byte[])this.getPublicKey());
    }

    public static P2PHKSignature createFromBytes(byte[] bytes) throws NulsException {
        P2PHKSignature sig = new P2PHKSignature();
        sig.parse(bytes, 0);
        return sig;
    }

    public byte[] getBytes() {
        try {
            return this.serialize();
        }
        catch (IOException e) {
            Log.error((Throwable)e);
            return null;
        }
    }

    @Override
    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.write(this.publicKey.length);
        stream.write(this.publicKey);
        stream.writeNulsData(this.signData);
    }

    @Override
    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        byte length = byteBuffer.readByte();
        this.publicKey = byteBuffer.readBytes(length);
        this.signData = new NulsSignData();
        this.signData.parse(byteBuffer);
    }

    public int size() {
        int size = 1 + this.publicKey.length;
        return size += SerializeUtils.sizeOfNulsData((NulsData)this.signData);
    }

    public Result verifySignature(NulsHash digestData) {
        boolean b = ECKey.verify((byte[])digestData.getBytes(), (byte[])this.signData.getSignBytes(), (byte[])this.publicKey);
        if (b) {
            return new Result(true);
        }
        return new Result(false);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Arrays.hashCode(this.signData.getSignBytes());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof P2PHKSignature)) {
            return false;
        }
        return Arrays.equals(this.signData.getSignBytes(), ((P2PHKSignature)obj).signData.getSignBytes());
    }
}

