/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.account;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.account.facade.AccountInfo;
import io.nuls.base.api.provider.account.facade.BackupAccountReq;
import io.nuls.base.api.provider.account.facade.CreateAccountReq;
import io.nuls.base.api.provider.account.facade.GenerateMultiSignAccountReq;
import io.nuls.base.api.provider.account.facade.GetAccountByAddressReq;
import io.nuls.base.api.provider.account.facade.GetAccountPrivateKeyByAddressReq;
import io.nuls.base.api.provider.account.facade.GetMultiSignAccountByAddressReq;
import io.nuls.base.api.provider.account.facade.ImportAccountByKeyStoreReq;
import io.nuls.base.api.provider.account.facade.ImportAccountByPrivateKeyReq;
import io.nuls.base.api.provider.account.facade.ImportKeyStoreFilesReq;
import io.nuls.base.api.provider.account.facade.KeyStoreReq;
import io.nuls.base.api.provider.account.facade.RemoveAccountReq;
import io.nuls.base.api.provider.account.facade.RemoveMultiSignAccountReq;
import io.nuls.base.api.provider.account.facade.SetAccountAliasReq;
import io.nuls.base.api.provider.account.facade.SetMultiSignAccountAliasReq;
import io.nuls.base.api.provider.account.facade.UpdatePasswordReq;
import io.nuls.base.api.provider.transaction.facade.MultiSignTransferRes;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.core.log.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public interface AccountService {
    public Result<String> createAccount(CreateAccountReq var1);

    public Result<String> backupAccount(BackupAccountReq var1);

    public Result<String> getAccountKeyStore(KeyStoreReq var1);

    public Result<String> importAccountByPrivateKey(ImportAccountByPrivateKeyReq var1);

    public Result<String> importAccountByKeyStore(ImportAccountByKeyStoreReq var1);

    public Result<String> importKeyStoreFiles(ImportKeyStoreFilesReq var1);

    public Result<Boolean> updatePassword(UpdatePasswordReq var1);

    public Result<AccountInfo> getAccountByAddress(GetAccountByAddressReq var1);

    public Result<MultiSigAccount> getMultiSignAccount(GetMultiSignAccountByAddressReq var1);

    public Result<AccountInfo> getAccountList();

    public Result<Boolean> removeAccount(RemoveAccountReq var1);

    public Result<String> getAccountPrivateKey(GetAccountPrivateKeyByAddressReq var1);

    public Result<String> setAccountAlias(SetAccountAliasReq var1);

    public Result<String> createMultiSignAccount(GenerateMultiSignAccountReq var1);

    public Result<Boolean> removeMultiSignAccount(RemoveMultiSignAccountReq var1);

    public Result<MultiSignTransferRes> setMultiSignAccountAlias(SetMultiSignAccountAliasReq var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String getAccountKeystoreDto(String path) {
        File file = null;
        try {
            file = new File(URLDecoder.decode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Log.error((String)"no files found", (Throwable)e);
        }
        if (null != file && file.isFile()) {
            StringBuilder ks = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                String str;
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((str = bufferedReader.readLine()) != null) {
                    if (str.isEmpty()) continue;
                    ks.append(str);
                }
                String string = ks.toString();
                return string;
            }
            catch (Exception exception) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        Log.error((String)"system error", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }
}

