/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.account;

import io.nuls.base.RPCUtil;
import io.nuls.base.api.provider.BaseReq;
import io.nuls.base.api.provider.BaseRpcService;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.account.AccountService;
import io.nuls.base.api.provider.account.facade.AccountInfo;
import io.nuls.base.api.provider.account.facade.BackupAccountReq;
import io.nuls.base.api.provider.account.facade.CreateAccountReq;
import io.nuls.base.api.provider.account.facade.GenerateMultiSignAccountReq;
import io.nuls.base.api.provider.account.facade.GetAccountByAddressReq;
import io.nuls.base.api.provider.account.facade.GetAccountPrivateKeyByAddressReq;
import io.nuls.base.api.provider.account.facade.GetMultiSignAccountByAddressReq;
import io.nuls.base.api.provider.account.facade.ImportAccountByKeyStoreReq;
import io.nuls.base.api.provider.account.facade.ImportAccountByPrivateKeyReq;
import io.nuls.base.api.provider.account.facade.ImportKeyStoreFilesReq;
import io.nuls.base.api.provider.account.facade.KeyStoreReq;
import io.nuls.base.api.provider.account.facade.RemoveAccountReq;
import io.nuls.base.api.provider.account.facade.RemoveMultiSignAccountReq;
import io.nuls.base.api.provider.account.facade.SetAccountAliasReq;
import io.nuls.base.api.provider.account.facade.SetMultiSignAccountAliasReq;
import io.nuls.base.api.provider.account.facade.UpdatePasswordReq;
import io.nuls.base.api.provider.transaction.facade.MultiSignTransferRes;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.log.Log;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.rpc.model.ModuleE;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Provider(value=Provider.ProviderType.RPC)
public class AccountServiceForRpc
extends BaseRpcService
implements AccountService {
    @Override
    public Result<String> createAccount(CreateAccountReq req) {
        return this._call("ac_createAccount", req, res -> {
            List list = (List)res.get("list");
            return this.success(list);
        });
    }

    @Override
    public Result<String> backupAccount(BackupAccountReq req) {
        return this.callReturnString("ac_exportAccountKeyStore", req, "path");
    }

    @Override
    public Result<String> getAccountKeyStore(KeyStoreReq req) {
        return this.callReturnString("ac_exportKeyStoreJson", req, "keystore");
    }

    @Override
    public Result<String> importAccountByPrivateKey(ImportAccountByPrivateKeyReq req) {
        return this.callReturnString("ac_importAccountByPriKey", req, "address");
    }

    @Override
    public Result<String> importAccountByKeyStore(ImportAccountByKeyStoreReq req) {
        return this.callReturnString("ac_importAccountByKeystore", req, "address");
    }

    @Override
    public Result<String> importKeyStoreFiles(ImportKeyStoreFilesReq req) {
        return this._call("ac_importsKeyStoreFiles", req, res -> {
            Boolean data = (Boolean)res.get("value");
            return this.success(data);
        });
    }

    @Override
    public Result<Boolean> updatePassword(UpdatePasswordReq req) {
        return this._call("ac_updatePassword", req, res -> {
            Boolean data = (Boolean)res.get("value");
            return this.success(data);
        });
    }

    @Override
    public Result<AccountInfo> getAccountByAddress(GetAccountByAddressReq req) {
        return this._call("ac_getAccountByAddress", req, res -> {
            if (res == null) {
                return AccountServiceForRpc.fail(RPC_ERROR_CODE, "account not found");
            }
            AccountInfo accountInfo = (AccountInfo)MapUtils.mapToBean((Map)res, (Object)new AccountInfo());
            return this.success(accountInfo);
        });
    }

    @Override
    public Result<MultiSigAccount> getMultiSignAccount(GetMultiSignAccountByAddressReq req) {
        return this._call("ac_getMultiSignAccount", req, res -> {
            try {
                String data = (String)res.get("value");
                if (data == null) {
                    return AccountServiceForRpc.fail(CommonCodeConstanst.DATA_ERROR, "not found account");
                }
                byte[] bytes = RPCUtil.decode((String)data);
                MultiSigAccount account = new MultiSigAccount();
                account.parse(new NulsByteBuffer(bytes));
                return this.success(account);
            }
            catch (Exception e) {
                Log.error((String)"getMultiSignAccount fail", (Throwable)e);
                return AccountServiceForRpc.fail(CommonCodeConstanst.FAILED);
            }
        });
    }

    @Override
    public Result<AccountInfo> getAccountList() {
        return this._call("ac_getAccountList", new BaseReq(), res -> {
            try {
                List list = MapUtils.mapsToObjects((List)((List)res.get("list")), AccountInfo.class);
                return this.success(list);
            }
            catch (Exception e) {
                Log.error((String)"getAccountList fail", (Throwable)e);
                return AccountServiceForRpc.fail(CommonCodeConstanst.FAILED);
            }
        });
    }

    @Override
    public Result<Boolean> removeAccount(RemoveAccountReq req) {
        return this._call("ac_removeAccount", req, res -> {
            Boolean data = (Boolean)res.get("value");
            return this.success(data);
        });
    }

    @Override
    public Result<String> getAccountPrivateKey(GetAccountPrivateKeyByAddressReq req) {
        return this.callReturnString("ac_getPriKeyByAddress", req, "priKey");
    }

    @Override
    public Result<String> setAccountAlias(SetAccountAliasReq req) {
        return this.callReturnString("ac_setAlias", req, "txHash");
    }

    @Override
    public Result<String> createMultiSignAccount(GenerateMultiSignAccountReq req) {
        return this.callReturnString("ac_createMultiSignAccount", req, "address");
    }

    @Override
    public Result<Boolean> removeMultiSignAccount(RemoveMultiSignAccountReq req) {
        return this._call("ac_removeMultiSignAccount", req, res -> {
            Boolean data = (Boolean)res.get("value");
            return this.success(data);
        });
    }

    @Override
    public Result<MultiSignTransferRes> setMultiSignAccountAlias(SetMultiSignAccountAliasReq req) {
        return this.callRpc(ModuleE.AC.abbr, "ac_setMultiSignAlias", req, data -> this.success((MultiSignTransferRes)MapUtils.mapToBean((Map)data, (Object)new MultiSignTransferRes())));
    }

    @Override
    protected <T, R> Result<T> call(String method, Object req, Function<R, Result> res) {
        return this.callRpc(ModuleE.AC.abbr, method, req, res);
    }

    private <T> Result<T> _call(String method, Object req, Function<Map, Result> callback) {
        return this.call(method, req, callback);
    }
}

