/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.crosschain;

import io.nuls.base.RPCUtil;
import io.nuls.base.api.provider.BaseRpcService;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.crosschain.CrossChainProvider;
import io.nuls.base.api.provider.crosschain.facade.CreateCrossTxReq;
import io.nuls.base.api.provider.crosschain.facade.CreateResetLocalVerifierTxReq;
import io.nuls.base.api.provider.crosschain.facade.GetCrossTxStateReq;
import io.nuls.base.api.provider.crosschain.facade.RehandleCtxReq;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Transaction;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ModuleE;
import java.util.Map;
import java.util.function.Function;

@Provider(value=Provider.ProviderType.RPC)
public class CrossChainProviderForRpc
extends BaseRpcService
implements CrossChainProvider {
    @Override
    protected <T, R> Result<T> call(String method, Object req, Function<R, Result> callback) {
        return this.callRpc(ModuleE.CC.abbr, method, req, callback);
    }

    @Override
    public Result<String> createCrossTx(CreateCrossTxReq req) {
        return this.callReturnString("createCrossTx", req, "txHash");
    }

    @Override
    public Result<Integer> getCrossTxState(GetCrossTxStateReq req) {
        return this._call("getCrossTxState", req, res -> {
            if (res == null) {
                return CrossChainProviderForRpc.fail(RPC_ERROR_CODE, "tx not found");
            }
            Integer data = (Integer)res.get("value");
            return this.success(data);
        });
    }

    @Override
    public Result<Transaction> getCrossTx(GetCrossTxStateReq req) {
        return this.call("getCrossChainTxInfoForCtxStatusPO", req, this::tranderTransaction);
    }

    @Override
    public Result<String> rehandleCtx(RehandleCtxReq req) {
        return this.callReturnString("ctxRehandle", req, "msg");
    }

    @Override
    public Result<String> resetLocalVerifier(CreateResetLocalVerifierTxReq req) {
        return this.callReturnString("createResetLocalVerifierTx", req, "txHash");
    }

    private <T> Result<T> _call(String method, Object req, Function<Map, Result> callback) {
        return this.call(method, req, callback);
    }

    private Result<Transaction> tranderTransaction(String hexString) {
        try {
            if (StringUtils.isNull((String)hexString)) {
                return CrossChainProviderForRpc.fail(CommonCodeConstanst.DATA_NOT_FOUND, "not found tx");
            }
            Transaction transaction = new Transaction();
            transaction.parse(new NulsByteBuffer(RPCUtil.decode((String)hexString)));
            return this.success(transaction);
        }
        catch (NulsException e) {
            Log.error((String)"Deserializationtransactionexception occurred", (Throwable)e);
            return CrossChainProviderForRpc.fail(CommonCodeConstanst.DESERIALIZE_ERROR);
        }
    }
}

