/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.api.provider.network;

import io.nuls.base.api.provider.BaseReq;
import io.nuls.base.api.provider.BaseRpcService;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.network.NetworkProvider;
import io.nuls.base.api.provider.network.facade.NetworkInfo;
import io.nuls.base.api.provider.network.facade.RemoteNodeInfo;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.rpc.model.ModuleE;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Provider(value=Provider.ProviderType.RPC)
public class NetworkProviderForRpc
extends BaseRpcService
implements NetworkProvider {
    @Override
    protected <T, R> Result<T> call(String method, Object req, Function<R, Result> callback) {
        return this.callRpc(ModuleE.NW.abbr, method, req, callback);
    }

    @Override
    public Result<NetworkInfo> getInfo() {
        BaseReq req = new BaseReq();
        req.setChainId(this.getChainId());
        Function<Map, Result> callback = res -> {
            NetworkInfo info = (NetworkInfo)MapUtils.mapToBean((Map)res, (Object)new NetworkInfo());
            return this.success(info);
        };
        return this.call("nw_info", req, callback);
    }

    @Override
    public Result<String> getNodes() {
        BaseReq req = new BaseReq();
        req.setChainId(this.getChainId());
        Function<List, Result> callback = res -> {
            ArrayList list = new ArrayList();
            res.stream().forEach(map -> {
                RemoteNodeInfo info = this.dataToRemoteNodeInfo((Map)map);
                list.add(info.getPeer());
            });
            return this.success(list);
        };
        return this.call("nw_nodes", req, callback);
    }

    @Override
    public Result<RemoteNodeInfo> getNodesInfo() {
        BaseReq req = new BaseReq();
        req.setChainId(this.getChainId());
        Function<List, Result> callback = res -> {
            ArrayList list = new ArrayList();
            res.stream().forEach(map -> {
                RemoteNodeInfo info = this.dataToRemoteNodeInfo((Map)map);
                list.add(info);
            });
            return this.success(list);
        };
        return this.call("nw_nodes", req, callback);
    }

    private RemoteNodeInfo dataToRemoteNodeInfo(Map<String, Object> data) {
        RemoteNodeInfo info = (RemoteNodeInfo)MapUtils.mapToBean(data, (Object)new RemoteNodeInfo());
        return info;
    }
}

