/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.utils.Exceptions;
import org.glassfish.grizzly.utils.Holder;
import org.glassfish.grizzly.utils.JdkVersion;
import org.glassfish.grizzly.utils.NullaryFunction;

public class UDPNIOConnection
extends NIOConnection {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOConnection.class);
    private static final boolean IS_MULTICAST_SUPPORTED;
    private static final Method JOIN_METHOD;
    private static final Method JOIN_WITH_SOURCE_METHOD;
    private static final Method MK_GET_NETWORK_INTERFACE_METHOD;
    private static final Method MK_GET_SOURCE_ADDRESS_METHOD;
    private static final Method MK_DROP_METHOD;
    private static final Method MK_BLOCK_METHOD;
    private static final Method MK_UNBLOCK_METHOD;
    private final Object multicastSync;
    private Map<InetAddress, Set<Object>> membershipKeysMap;
    Holder<SocketAddress> localSocketAddressHolder;
    Holder<SocketAddress> peerSocketAddressHolder;
    private int readBufferSize = -1;
    private int writeBufferSize = -1;

    public UDPNIOConnection(UDPNIOTransport transport, DatagramChannel channel) {
        super(transport);
        this.channel = channel;
        this.resetProperties();
        this.multicastSync = IS_MULTICAST_SUPPORTED ? new Object() : null;
    }

    public boolean isConnected() {
        return this.channel != null && ((DatagramChannel)this.channel).isConnected();
    }

    public void join(InetAddress group, NetworkInterface networkInterface) throws IOException {
        this.join(group, networkInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(InetAddress group, NetworkInterface networkInterface, InetAddress source) throws IOException {
        if (!IS_MULTICAST_SUPPORTED) {
            throw new UnsupportedOperationException("JDK 1.7+ required");
        }
        if (group == null) {
            throw new IllegalArgumentException("group parameter can't be null");
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("networkInterface parameter can't be null");
        }
        Object object = this.multicastSync;
        synchronized (object) {
            Set<Object> keySet;
            Object membershipKey = UDPNIOConnection.join0((DatagramChannel)this.channel, group, networkInterface, source);
            if (this.membershipKeysMap == null) {
                this.membershipKeysMap = new HashMap<InetAddress, Set<Object>>();
            }
            if ((keySet = this.membershipKeysMap.get(group)) == null) {
                keySet = new HashSet<Object>();
                this.membershipKeysMap.put(group, keySet);
            }
            keySet.add(membershipKey);
        }
    }

    public void drop(InetAddress group, NetworkInterface networkInterface) throws IOException {
        this.drop(group, networkInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(InetAddress group, NetworkInterface networkInterface, InetAddress source) throws IOException {
        if (!IS_MULTICAST_SUPPORTED) {
            throw new UnsupportedOperationException("JDK 1.7+ required");
        }
        if (group == null) {
            throw new IllegalArgumentException("group parameter can't be null");
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("networkInterface parameter can't be null");
        }
        Object object = this.multicastSync;
        synchronized (object) {
            Set<Object> keys;
            if (this.membershipKeysMap != null && (keys = this.membershipKeysMap.get(group)) != null) {
                Iterator<Object> it = keys.iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    if (networkInterface.equals(UDPNIOConnection.networkInterface0(key)) && (source == null && UDPNIOConnection.sourceAddress0(key) == null || source != null && source.equals(UDPNIOConnection.sourceAddress0(key)))) {
                        UDPNIOConnection.drop0(key);
                        it.remove();
                    }
                    if (!keys.isEmpty()) continue;
                    this.membershipKeysMap.remove(group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAll(InetAddress group, NetworkInterface networkInterface) throws IOException {
        if (!IS_MULTICAST_SUPPORTED) {
            throw new UnsupportedOperationException("JDK 1.7+ required");
        }
        if (group == null) {
            throw new IllegalArgumentException("group parameter can't be null");
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("networkInterface parameter can't be null");
        }
        Object object = this.multicastSync;
        synchronized (object) {
            Set<Object> keys;
            if (this.membershipKeysMap != null && (keys = this.membershipKeysMap.get(group)) != null) {
                Iterator<Object> it = keys.iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    if (!networkInterface.equals(UDPNIOConnection.networkInterface0(key))) continue;
                    UDPNIOConnection.drop0(key);
                    it.remove();
                }
                if (keys.isEmpty()) {
                    this.membershipKeysMap.remove(group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block(InetAddress group, NetworkInterface networkInterface, InetAddress source) throws IOException {
        if (!IS_MULTICAST_SUPPORTED) {
            throw new UnsupportedOperationException("JDK 1.7+ required");
        }
        if (group == null) {
            throw new IllegalArgumentException("group parameter can't be null");
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("networkInterface parameter can't be null");
        }
        Object object = this.multicastSync;
        synchronized (object) {
            Set<Object> keys;
            if (this.membershipKeysMap != null && (keys = this.membershipKeysMap.get(group)) != null) {
                for (Object key : keys) {
                    if (!networkInterface.equals(UDPNIOConnection.networkInterface0(key)) || UDPNIOConnection.sourceAddress0(key) != null) continue;
                    UDPNIOConnection.block0(key, source);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock(InetAddress group, NetworkInterface networkInterface, InetAddress source) throws IOException {
        if (!IS_MULTICAST_SUPPORTED) {
            throw new UnsupportedOperationException("JDK 1.7+ required");
        }
        if (group == null) {
            throw new IllegalArgumentException("group parameter can't be null");
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("networkInterface parameter can't be null");
        }
        Object object = this.multicastSync;
        synchronized (object) {
            Set<Object> keys;
            if (this.membershipKeysMap != null && (keys = this.membershipKeysMap.get(group)) != null) {
                for (Object key : keys) {
                    if (!networkInterface.equals(UDPNIOConnection.networkInterface0(key)) || UDPNIOConnection.sourceAddress0(key) != null) continue;
                    UDPNIOConnection.unblock0(key, source);
                }
            }
        }
    }

    @Override
    protected void setSelectionKey(SelectionKey selectionKey) {
        super.setSelectionKey(selectionKey);
    }

    @Override
    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        super.setSelectorRunner(selectorRunner);
    }

    protected boolean notifyReady() {
        return connectCloseSemaphoreUpdater.compareAndSet(this, null, NOTIFICATION_INITIALIZED);
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.peerSocketAddressHolder.get();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localSocketAddressHolder.get();
    }

    protected final void resetProperties() {
        if (this.channel != null) {
            this.setReadBufferSize(this.transport.getReadBufferSize());
            this.setWriteBufferSize(this.transport.getWriteBufferSize());
            int transportMaxAsyncWriteQueueSize = this.transport.getAsyncQueueIO().getWriter().getMaxPendingBytesPerConnection();
            this.setMaxAsyncWriteQueueSize(transportMaxAsyncWriteQueueSize == -2 ? this.getWriteBufferSize() * 4 : transportMaxAsyncWriteQueueSize);
            this.localSocketAddressHolder = Holder.lazyHolder(new NullaryFunction<SocketAddress>(){

                @Override
                public SocketAddress evaluate() {
                    return ((DatagramChannel)UDPNIOConnection.this.channel).socket().getLocalSocketAddress();
                }
            });
            this.peerSocketAddressHolder = Holder.lazyHolder(new NullaryFunction<SocketAddress>(){

                @Override
                public SocketAddress evaluate() {
                    return ((DatagramChannel)UDPNIOConnection.this.channel).socket().getRemoteSocketAddress();
                }
            });
        }
    }

    @Override
    public int getReadBufferSize() {
        if (this.readBufferSize >= 0) {
            return this.readBufferSize;
        }
        try {
            this.readBufferSize = ((DatagramChannel)this.channel).socket().getReceiveBufferSize();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, LogMessages.WARNING_GRIZZLY_CONNECTION_GET_READBUFFER_SIZE_EXCEPTION(), e);
            this.readBufferSize = 0;
        }
        return this.readBufferSize;
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        if (readBufferSize > 0) {
            try {
                int currentReadBufferSize = ((DatagramChannel)this.channel).socket().getReceiveBufferSize();
                if (readBufferSize > currentReadBufferSize) {
                    ((DatagramChannel)this.channel).socket().setReceiveBufferSize(readBufferSize);
                }
                this.readBufferSize = readBufferSize;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_READBUFFER_SIZE_EXCEPTION(), e);
            }
        }
    }

    @Override
    public int getWriteBufferSize() {
        if (this.writeBufferSize >= 0) {
            return this.writeBufferSize;
        }
        try {
            this.writeBufferSize = ((DatagramChannel)this.channel).socket().getSendBufferSize();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, LogMessages.WARNING_GRIZZLY_CONNECTION_GET_WRITEBUFFER_SIZE_EXCEPTION(), e);
            this.writeBufferSize = 0;
        }
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        if (writeBufferSize > 0) {
            try {
                int currentSendBufferSize = ((DatagramChannel)this.channel).socket().getSendBufferSize();
                if (writeBufferSize > currentSendBufferSize) {
                    ((DatagramChannel)this.channel).socket().setSendBufferSize(writeBufferSize);
                }
                this.writeBufferSize = writeBufferSize;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_WRITEBUFFER_SIZE_EXCEPTION(), e);
            }
        }
    }

    @Override
    protected void enableInitialOpRead() throws IOException {
        super.enableInitialOpRead();
    }

    protected final void onConnect() throws IOException {
        UDPNIOConnection.notifyProbesConnect(this);
    }

    protected final void onRead(Buffer data, int size) {
        if (size > 0) {
            UDPNIOConnection.notifyProbesRead(this, data, size);
        }
        this.checkEmptyRead(size);
    }

    protected final void onWrite(Buffer data, int size) {
        UDPNIOConnection.notifyProbesWrite(this, data, size);
    }

    @Override
    public boolean canWrite() {
        return this.transport.getWriter(this).canWrite(this);
    }

    @Override
    @Deprecated
    public boolean canWrite(int length) {
        return this.transport.getWriter(this).canWrite(this);
    }

    @Override
    public void notifyCanWrite(WriteHandler writeHandler) {
        this.transport.getWriter(this).notifyWritePossible(this, writeHandler);
    }

    @Override
    @Deprecated
    public void notifyCanWrite(WriteHandler handler, int length) {
        this.transport.getWriter(this).notifyWritePossible(this, handler);
    }

    void setMonitoringProbes(ConnectionProbe[] monitoringProbes) {
        this.monitoringConfig.addProbes(monitoringProbes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UDPNIOConnection");
        sb.append("{localSocketAddress=").append(this.localSocketAddressHolder);
        sb.append(", peerSocketAddress=").append(this.peerSocketAddressHolder);
        sb.append('}');
        return sb.toString();
    }

    private static Object join0(DatagramChannel channel, InetAddress group, NetworkInterface networkInterface, InetAddress source) throws IOException {
        return source == null ? UDPNIOConnection.invoke(channel, JOIN_METHOD, group, networkInterface) : UDPNIOConnection.invoke(channel, JOIN_WITH_SOURCE_METHOD, group, networkInterface, source);
    }

    private static NetworkInterface networkInterface0(Object membershipKey) throws IOException {
        return (NetworkInterface)UDPNIOConnection.invoke(membershipKey, MK_GET_NETWORK_INTERFACE_METHOD, new Object[0]);
    }

    private static InetAddress sourceAddress0(Object membershipKey) throws IOException {
        return (InetAddress)UDPNIOConnection.invoke(membershipKey, MK_GET_SOURCE_ADDRESS_METHOD, new Object[0]);
    }

    private static void drop0(Object membershipKey) throws IOException {
        UDPNIOConnection.invoke(membershipKey, MK_DROP_METHOD, new Object[0]);
    }

    private static void block0(Object membershipKey, InetAddress sourceAddress) throws IOException {
        UDPNIOConnection.invoke(membershipKey, MK_BLOCK_METHOD, sourceAddress);
    }

    private static void unblock0(Object membershipKey, InetAddress sourceAddress) throws IOException {
        UDPNIOConnection.invoke(membershipKey, MK_UNBLOCK_METHOD, sourceAddress);
    }

    private static Object invoke(Object object, Method method, Object ... params) throws IOException {
        try {
            return method.invoke(object, params);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw Exceptions.makeIOException(t);
        }
        catch (Throwable t) {
            throw Exceptions.makeIOException(t);
        }
    }

    private static Class<?> loadClass(String cname) throws Throwable {
        return ClassLoader.getSystemClassLoader().loadClass(cname);
    }

    static {
        JdkVersion jdkVersion = JdkVersion.getJdkVersion();
        JdkVersion minimumVersion = JdkVersion.parseVersion("1.7.0");
        boolean isInitialized = false;
        Method join = null;
        Method joinWithSource = null;
        Method mkGetNetworkInterface = null;
        Method mkGetSourceAddress = null;
        Method mkDrop = null;
        Method mkBlock = null;
        Method mkUnblock = null;
        if (minimumVersion.compareTo(jdkVersion) <= 0) {
            try {
                join = DatagramChannel.class.getMethod("join", InetAddress.class, NetworkInterface.class);
                joinWithSource = DatagramChannel.class.getMethod("join", InetAddress.class, NetworkInterface.class, InetAddress.class);
                Class<?> membershipKeyClass = UDPNIOConnection.loadClass("java.nio.channels.MembershipKey");
                mkGetNetworkInterface = membershipKeyClass.getDeclaredMethod("networkInterface", new Class[0]);
                mkGetSourceAddress = membershipKeyClass.getDeclaredMethod("sourceAddress", new Class[0]);
                mkDrop = membershipKeyClass.getDeclaredMethod("drop", new Class[0]);
                mkBlock = membershipKeyClass.getDeclaredMethod("block", InetAddress.class);
                mkUnblock = membershipKeyClass.getDeclaredMethod("unblock", InetAddress.class);
                isInitialized = true;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_UDPMULTICASTING_EXCEPTIONE(), t);
            }
        }
        if (isInitialized) {
            IS_MULTICAST_SUPPORTED = true;
            JOIN_METHOD = join;
            JOIN_WITH_SOURCE_METHOD = joinWithSource;
            MK_GET_NETWORK_INTERFACE_METHOD = mkGetNetworkInterface;
            MK_GET_SOURCE_ADDRESS_METHOD = mkGetSourceAddress;
            MK_DROP_METHOD = mkDrop;
            MK_BLOCK_METHOD = mkBlock;
            MK_UNBLOCK_METHOD = mkUnblock;
        } else {
            IS_MULTICAST_SUPPORTED = false;
            MK_UNBLOCK_METHOD = null;
            MK_BLOCK_METHOD = null;
            MK_DROP_METHOD = null;
            MK_GET_SOURCE_ADDRESS_METHOD = null;
            MK_GET_NETWORK_INTERFACE_METHOD = null;
            JOIN_WITH_SOURCE_METHOD = null;
            JOIN_METHOD = null;
        }
    }
}

