/*
 * Decompiled with CFR 0.152.
 */
package net.steppschuh.markdowngenerator.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.steppschuh.markdowngenerator.MarkdownElement;
import net.steppschuh.markdowngenerator.table.TableRow;
import net.steppschuh.markdowngenerator.util.StringUtil;

public class Table
extends MarkdownElement {
    public static final String SEPERATOR = "|";
    public static final String WHITESPACE = " ";
    public static final String DEFAULT_TRIMMING_INDICATOR = "~";
    public static final int DEFAULT_MINIMUM_COLUMN_WIDTH = 3;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_LEFT = 2;
    public static final int ALIGN_RIGHT = 3;
    private List<TableRow> rows = new ArrayList<TableRow>();
    private List<Integer> alignments = new ArrayList<Integer>();
    private boolean firstRowIsHeader = true;
    private int minimumColumnWidth = 3;
    private String trimmingIndicator = "~";

    public Table() {
    }

    public Table(List<TableRow> rows) {
        this();
        this.rows = rows;
    }

    public Table(List<TableRow> rows, List<Integer> alignments) {
        this(rows);
        this.alignments = alignments;
    }

    @Override
    public String serialize() {
        boolean headerSeperatorAdded;
        Map<Integer, Integer> columnWidths = Table.getColumnWidths(this.rows, this.minimumColumnWidth);
        StringBuilder sb = new StringBuilder();
        String headerSeperator = Table.generateHeaderSeperator(columnWidths, this.alignments);
        boolean bl = headerSeperatorAdded = !this.firstRowIsHeader;
        if (!this.firstRowIsHeader) {
            sb.append(headerSeperator).append(System.lineSeparator());
        }
        for (TableRow row : this.rows) {
            for (int columnIndex = 0; columnIndex < columnWidths.size(); ++columnIndex) {
                Object valueObject;
                sb.append(SEPERATOR);
                String value = "";
                if (row.getColumns().size() > columnIndex && (valueObject = row.getColumns().get(columnIndex)) != null) {
                    value = valueObject.toString();
                }
                if (value.equals(this.trimmingIndicator)) {
                    value = StringUtil.fillUpLeftAligned(value, this.trimmingIndicator, columnWidths.get(columnIndex));
                    value = StringUtil.surroundValueWith(value, WHITESPACE);
                } else {
                    int alignment = Table.getAlignment(this.alignments, columnIndex);
                    value = StringUtil.surroundValueWith(value, WHITESPACE);
                    value = StringUtil.fillUpAligned(value, WHITESPACE, columnWidths.get(columnIndex) + 2, alignment);
                }
                sb.append(value);
                if (columnIndex != row.getColumns().size() - 1) continue;
                sb.append(SEPERATOR);
            }
            if (this.rows.indexOf(row) < this.rows.size() - 1) {
                sb.append(System.lineSeparator());
            }
            if (headerSeperatorAdded) continue;
            sb.append(headerSeperator).append(System.lineSeparator());
            headerSeperatorAdded = true;
        }
        return sb.toString();
    }

    public Table trim(int rowsToKeep) {
        this.rows = Table.trim(this, rowsToKeep, this.trimmingIndicator).getRows();
        return this;
    }

    public static Table trim(Table table, int rowsToKeep, String trimmingIndicator) {
        if (table.getRows().size() <= rowsToKeep) {
            return table;
        }
        int trimmedEntriesCount = table.getRows().size() - (table.getRows().size() - rowsToKeep);
        int trimmingStartIndex = Math.round(trimmedEntriesCount / 2) + 1;
        int trimmingStopIndex = table.getRows().size() - trimmingStartIndex;
        ArrayList<TableRow> trimmedRows = new ArrayList<TableRow>();
        for (int i = trimmingStartIndex; i <= trimmingStopIndex; ++i) {
            trimmedRows.add(table.getRows().get(i));
        }
        table.getRows().removeAll(trimmedRows);
        TableRow trimmingIndicatorRow = new TableRow();
        for (int columnIndex = 0; columnIndex < table.getRows().get(0).getColumns().size(); ++columnIndex) {
            trimmingIndicatorRow.getColumns().add(trimmingIndicator);
        }
        table.getRows().add(trimmingStartIndex, trimmingIndicatorRow);
        return table;
    }

    public static String generateHeaderSeperator(Map<Integer, Integer> columnWidths, List<Integer> alignments) {
        StringBuilder sb = new StringBuilder();
        for (int columnIndex = 0; columnIndex < columnWidths.entrySet().size(); ++columnIndex) {
            sb.append(SEPERATOR);
            String value = StringUtil.fillUpLeftAligned("", "-", columnWidths.get(columnIndex));
            int alignment = Table.getAlignment(alignments, columnIndex);
            switch (alignment) {
                case 3: {
                    value = WHITESPACE + value + ":";
                    break;
                }
                case 1: {
                    value = ":" + value + ":";
                    break;
                }
                default: {
                    value = StringUtil.surroundValueWith(value, WHITESPACE);
                }
            }
            sb.append(value);
            if (columnIndex != columnWidths.entrySet().size() - 1) continue;
            sb.append(SEPERATOR);
        }
        return sb.toString();
    }

    public static Map<Integer, Integer> getColumnWidths(List<TableRow> rows, int minimumColumnWidth) {
        HashMap<Integer, Integer> columnWidths = new HashMap<Integer, Integer>();
        if (rows.isEmpty()) {
            return columnWidths;
        }
        for (int columnIndex = 0; columnIndex < rows.get(0).getColumns().size(); ++columnIndex) {
            columnWidths.put(columnIndex, Table.getMaximumItemLength(rows, columnIndex, minimumColumnWidth));
        }
        return columnWidths;
    }

    public static int getMaximumItemLength(List<TableRow> rows, int columnIndex, int minimumColumnWidth) {
        int maximum = minimumColumnWidth;
        for (TableRow row : rows) {
            Object value;
            if (row.getColumns().size() < columnIndex + 1 || (value = row.getColumns().get(columnIndex)) == null) continue;
            maximum = Math.max(value.toString().length(), maximum);
        }
        return maximum;
    }

    public static int getAlignment(List<Integer> alignments, int columnIndex) {
        if (alignments.isEmpty()) {
            return 2;
        }
        if (columnIndex >= alignments.size()) {
            columnIndex = alignments.size() - 1;
        }
        return alignments.get(columnIndex);
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public void setRows(List<TableRow> rows) {
        this.rows = rows;
        this.invalidateSerialized();
    }

    public List<Integer> getAlignments() {
        return this.alignments;
    }

    public void setAlignments(List<Integer> alignments) {
        this.alignments = alignments;
        this.invalidateSerialized();
    }

    public boolean isFirstRowHeader() {
        return this.firstRowIsHeader;
    }

    public void useFirstRowAsHeader(boolean firstRowIsHeader) {
        this.firstRowIsHeader = firstRowIsHeader;
        this.invalidateSerialized();
    }

    public int getMinimumColumnWidth() {
        return this.minimumColumnWidth;
    }

    public void setMinimumColumnWidth(int minimumColumnWidth) {
        this.minimumColumnWidth = minimumColumnWidth;
        this.invalidateSerialized();
    }

    public String getTrimmingIndicator() {
        return this.trimmingIndicator;
    }

    public void setTrimmingIndicator(String trimmingIndicator) {
        this.trimmingIndicator = trimmingIndicator;
    }

    public static class Builder {
        private Table table = new Table();
        private int rowLimit;

        public Builder withRows(List<TableRow> tableRows) {
            this.table.setRows(tableRows);
            return this;
        }

        public Builder addRow(TableRow tableRow) {
            this.table.getRows().add(tableRow);
            return this;
        }

        public Builder addRow(Object ... objects) {
            TableRow<Object> tableRow = new TableRow<Object>(Arrays.asList(objects));
            this.table.getRows().add(tableRow);
            return this;
        }

        public Builder withAlignments(List<Integer> alignments) {
            this.table.setAlignments(alignments);
            return this;
        }

        public Builder withAlignments(Integer ... alignments) {
            return this.withAlignments(Arrays.asList(alignments));
        }

        public Builder withAlignment(int alignment) {
            return this.withAlignments(Collections.singletonList(alignment));
        }

        public Builder withRowLimit(int rowLimit) {
            this.rowLimit = rowLimit;
            return this;
        }

        public Builder withTrimmingIndicator(String trimmingIndicator) {
            this.table.setTrimmingIndicator(trimmingIndicator);
            return this;
        }

        public Table build() {
            if (this.rowLimit > 0) {
                this.table.trim(this.rowLimit);
            }
            return this.table;
        }
    }
}

