/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.base.protocol;

import io.nuls.base.protocol.MessageDefine;
import io.nuls.base.protocol.Protocol;
import io.nuls.base.protocol.ProtocolConfigJson;
import io.nuls.base.protocol.ProtocolConstant;
import io.nuls.base.protocol.ProtocolGroupManager;
import io.nuls.base.protocol.TxDefine;
import io.nuls.core.io.IoUtils;
import io.nuls.core.parse.JSONUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ProtocolLoader {
    static final short DEFAULT_BEGIN_PROTOCOL_VERSION = 1;

    public static void load(int chainId, String protocolConfigJson) throws Exception {
        if (ProtocolGroupManager.isLoadProtocol()) {
            List protocolConfigs = JSONUtils.json2list((String)protocolConfigJson, ProtocolConfigJson.class);
            protocolConfigs.sort(ProtocolConstant.PROTOCOL_CONFIG_COMPARATOR);
            HashMap<Short, Protocol> protocolsMap = new HashMap<Short, Protocol>(protocolConfigs.size());
            for (ProtocolConfigJson configJson : protocolConfigs) {
                Protocol protocol = new Protocol();
                protocol.setVersion(configJson.getVersion());
                short extend = configJson.getExtend();
                HashSet<MessageDefine> msgList = new HashSet<MessageDefine>();
                HashSet<TxDefine> txList = new HashSet<TxDefine>();
                List<MessageDefine> validMessages = configJson.getValidMsgs();
                List<TxDefine> validTransactions = configJson.getValidTxs();
                HashSet<String> discardMsgs = new HashSet<String>();
                String[] strings1 = configJson.getInvalidMsgs().split(",");
                Collections.addAll(discardMsgs, strings1);
                discardMsgs.remove("");
                HashSet<String> discardTxs = new HashSet<String>();
                String[] strings = configJson.getInvalidTxs().split(",");
                Collections.addAll(discardTxs, strings);
                discardTxs.remove("");
                if (extend > 0) {
                    Protocol parent = (Protocol)protocolsMap.get(extend);
                    List msg = validMessages.stream().map(MessageDefine::getName).collect(Collectors.toList());
                    discardMsgs.addAll(parent.getInvalidMsgs());
                    discardMsgs.removeIf(msg::contains);
                    msgList.addAll(parent.getAllowMsg());
                    msgList.removeIf(e -> msg.contains(e.getName()));
                    List tx = validTransactions.stream().map(TxDefine::getType).collect(Collectors.toList());
                    discardTxs.addAll(parent.getInvalidTxs());
                    discardTxs.removeIf(e -> tx.contains(Short.valueOf(e)));
                    txList.addAll(parent.getAllowTx());
                    txList.removeIf(e -> tx.contains(e.getType()));
                }
                msgList.addAll(validMessages);
                msgList.removeIf(e -> discardMsgs.contains(e.getName()));
                txList.addAll(validTransactions);
                txList.removeIf(e -> discardTxs.contains("" + e.getType()));
                protocol.setAllowMsg(msgList);
                protocol.setAllowTx(txList);
                protocol.setInvalidTxs(discardTxs);
                protocol.setInvalidMsgs(discardMsgs);
                protocolsMap.put(protocol.getVersion(), protocol);
            }
            ProtocolGroupManager.init(chainId, protocolsMap, (short)1);
        } else {
            ProtocolGroupManager.init(chainId, null, (short)1);
        }
    }

    public static void load(int chainId) throws Exception {
        ProtocolLoader.load(chainId, true);
    }

    public static void load(int chainId, boolean loadProtocol) throws Exception {
        ProtocolGroupManager.setLoadProtocol(loadProtocol);
        if (loadProtocol) {
            ProtocolLoader.load(chainId, IoUtils.read((String)ProtocolConstant.PROTOCOL_CONFIG_FILE));
        } else {
            ProtocolLoader.load(chainId, null);
        }
    }
}

