/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.core.config;

import io.nuls.core.core.config.ConfigurationLoader;
import io.nuls.core.core.config.ModuleConfigParser;
import io.nuls.core.log.Log;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.ini4j.Config;
import org.ini4j.Ini;

public class IniModuleConfigParser
implements ModuleConfigParser {
    @Override
    public String fileSuffix() {
        return "ini";
    }

    @Override
    public Map<String, Map<String, ConfigurationLoader.ConfigItem>> parse(String configFile, InputStream inputStream) throws Exception {
        Config cfg = new Config();
        cfg.setMultiSection(true);
        Ini ini = new Ini();
        ini.setConfig(cfg);
        ini.load(inputStream);
        HashMap<String, Map<String, ConfigurationLoader.ConfigItem>> res = new HashMap<String, Map<String, ConfigurationLoader.ConfigItem>>(ini.size());
        ini.values().forEach(s -> {
            HashMap domainValues = new HashMap(s.size());
            s.forEach((key, value) -> domainValues.put(key, new ConfigurationLoader.ConfigItem(configFile, (String)value)));
            res.put(s.getName(), domainValues);
        });
        Log.debug("{},load configuration\uff1a{}", configFile, res);
        return res;
    }
}

