/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.core.ioc;

import io.nuls.core.model.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ScanUtil {
    private static final ClassLoader CLASS_LOADER = ScanUtil.class.getClassLoader();
    private static final String FILE_TYPE = "file";
    private static final String JAR_TYPE = "jar";
    private static final String CLASS_TYPE = ".class";

    public static List<Class> scan(String packageName) {
        Enumeration<URL> dirs;
        if (StringUtils.isBlank(packageName)) {
            packageName = "io.nuls";
        }
        ArrayList<Class> list = new ArrayList<Class>();
        try {
            dirs = Thread.currentThread().getContextClassLoader().getResources(packageName.replace(".", "/"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null == dirs) {
            return list;
        }
        while (dirs.hasMoreElements()) {
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if (FILE_TYPE.equals(protocol)) {
                ScanUtil.findClassLocal(packageName, url.getPath(), list);
                continue;
            }
            if (!JAR_TYPE.equals(protocol)) continue;
            ScanUtil.findClassJar(packageName, url.getPath(), list);
        }
        return list;
    }

    public static void findClassLocal(String packageName, String filePath, List<Class> list) {
        File file = new File(filePath);
        file.listFiles(new LocalFileFilter(packageName, list));
    }

    private static void findClassJar(String packageName, String pathName, List<Class> list) {
        JarFile jarFile;
        if (StringUtils.isBlank(pathName) || list == null) {
            return;
        }
        try {
            int index = pathName.indexOf("!");
            if (index > 0) {
                pathName = pathName.substring(0, index);
            }
            URL url = new URL(pathName);
            jarFile = new JarFile(url.getFile());
        }
        catch (IOException e) {
            throw new RuntimeException("could not be parsed as a URI reference");
        }
        packageName = packageName.replace(".", "/");
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            Class<?> clazz;
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.contains(packageName) || jarEntryName.equals(packageName + "/") || !jarEntryName.endsWith(CLASS_TYPE)) continue;
            try {
                String className = jarEntry.getName().replace("/", ".").replace(CLASS_TYPE, "");
                clazz = CLASS_LOADER.loadClass(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                continue;
            }
            list.add(clazz);
        }
    }

    static class LocalFileFilter
    implements FileFilter {
        private List<Class> list;
        private String packageName;

        LocalFileFilter(String packageName, List<Class> list) {
            this.list = list;
            this.packageName = packageName;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                ScanUtil.findClassLocal(this.packageName + "." + file.getName(), file.getPath(), this.list);
                return true;
            }
            if (file.getName().endsWith(ScanUtil.CLASS_TYPE)) {
                Class<?> clazz;
                try {
                    clazz = CLASS_LOADER.loadClass(this.packageName + "." + file.getName().replace(ScanUtil.CLASS_TYPE, ""));
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
                this.list.add(clazz);
                return true;
            }
            return false;
        }
    }
}

