/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.core.ioc;

import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.annotation.Configuration;
import io.nuls.core.core.annotation.Controller;
import io.nuls.core.core.annotation.Interceptor;
import io.nuls.core.core.annotation.Order;
import io.nuls.core.core.annotation.Persist;
import io.nuls.core.core.annotation.Service;
import io.nuls.core.core.annotation.Value;
import io.nuls.core.core.config.ConfigSetting;
import io.nuls.core.core.config.ConfigurationLoader;
import io.nuls.core.core.inteceptor.DefaultMethodInterceptor;
import io.nuls.core.core.inteceptor.base.BeanMethodInterceptor;
import io.nuls.core.core.inteceptor.base.BeanMethodInterceptorManager;
import io.nuls.core.core.ioc.ScanUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

public class SpringLiteContext {
    private static final Map<String, Object> BEAN_OK_MAP = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> BEAN_TEMP_MAP = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Class> BEAN_TYPE_MAP = new ConcurrentHashMap<String, Class>();
    private static final Map<Class, Set<String>> CLASS_NAME_SET_MAP = new ConcurrentHashMap<Class, Set<String>>();
    private static MethodInterceptor interceptor;

    public static void init(String ... packName) {
        SpringLiteContext.init(new DefaultMethodInterceptor(), packName);
    }

    public static void init(String packName, MethodInterceptor interceptor) {
        SpringLiteContext.init(interceptor, packName);
    }

    public static void init(MethodInterceptor interceptor, String ... packName) {
        if (packName.length == 0) {
            throw new IllegalArgumentException("spring lite init package can't be null");
        }
        SpringLiteContext.interceptor = interceptor;
        Log.info("spring lite scan package : " + Arrays.toString(packName));
        HashSet<Class> classes = new HashSet<Class>(ScanUtil.scan("io.nuls.core.core.config"));
        Arrays.stream(packName).forEach(pack -> classes.addAll(ScanUtil.scan(pack)));
        classes.stream().sorted((b1, b2) -> SpringLiteContext.getOrderByClass(b1) > SpringLiteContext.getOrderByClass(b2) ? 1 : -1).forEach(SpringLiteContext::checkBeanClass);
        SpringLiteContext.configurationInjectToBean();
        SpringLiteContext.autowireFields();
        SpringLiteContext.callAfterPropertiesSet();
    }

    private static void configurationInjectToBean() {
        ConfigurationLoader configLoader = SpringLiteContext.getBean(ConfigurationLoader.class);
        configLoader.load();
        HashMap<String, ConfigurationLoader.ConfigItem> values = new HashMap<String, ConfigurationLoader.ConfigItem>();
        BEAN_TEMP_MAP.forEach((key1, bean) -> {
            Class cls = BEAN_TYPE_MAP.get(key1);
            Configuration configuration = cls.getAnnotation(Configuration.class);
            if (configuration != null) {
                String domain = configuration.domain();
                Set<Field> fields = SpringLiteContext.getFieldSet(cls);
                fields.forEach(field -> {
                    Persist persist;
                    Value annValue = field.getAnnotation(Value.class);
                    String key = field.getName();
                    if (annValue != null) {
                        key = annValue.value();
                    }
                    boolean readPersist = (persist = field.getAnnotation(Persist.class)) != null;
                    ConfigurationLoader.ConfigItem configItem = readPersist ? configLoader.getConfigItemForPersist(domain, key) : configLoader.getConfigItem(domain, key);
                    if ("nuls-cores".equalsIgnoreCase(domain)) {
                        configItem = configLoader.getConfigItemForCore(key);
                    }
                    if (configItem == null) {
                        Log.warn("config item :{} not setting", key);
                    } else {
                        ConfigSetting.set(bean, field, configItem.getValue());
                        values.put(cls.getSimpleName() + "." + field.getName(), configItem);
                    }
                });
            } else {
                Set<Field> fields = SpringLiteContext.getFieldSet(cls);
                fields.forEach(field -> {
                    Value annValue = field.getAnnotation(Value.class);
                    if (annValue != null) {
                        String key = annValue.value();
                        if (configLoader.getConfigData().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("global") && ((Map)entry.getValue()).containsKey(key)).count() > 1L) {
                            throw new IllegalArgumentException("io.nuls.tools.core.annotation.Value " + key + " config item Find more ");
                        }
                        ConfigurationLoader.ConfigItem configItem = configLoader.getConfigItem(key);
                        if (configItem == null) {
                            Log.warn("not found config item : " + key + " to " + cls);
                            try {
                                field.setAccessible(true);
                                values.put(cls.getSimpleName() + "." + field.getName(), new ConfigurationLoader.ConfigItem("DEFAULT", String.valueOf(field.get(bean))));
                                field.setAccessible(false);
                            }
                            catch (IllegalAccessException e) {
                                Log.error(e.getMessage());
                            }
                        } else {
                            ConfigSetting.set(bean, field, configItem.getValue());
                            values.put(cls.getSimpleName() + "." + field.getName(), configItem);
                        }
                    }
                });
            }
        });
        Optional maxItem = values.keySet().stream().max((d1, d2) -> d1.length() > d2.length() ? 1 : -1);
        int maxKeyLength = maxItem.isPresent() ? ((String)maxItem.get()).length() : 0;
        Log.info("Configuration information:");
        values.forEach((key, value) -> Log.info("{} : {} ==> {}", key + " ".repeat(Math.max(0, maxKeyLength - key.length())), value.getValue(), value.getConfigFile()));
    }

    private static void autowireFields() {
        HashSet<String> keySet = new HashSet<String>(BEAN_TEMP_MAP.keySet());
        for (String key : keySet) {
            try {
                Object bean = BEAN_TEMP_MAP.get(key);
                SpringLiteContext.injectionBeanFields(bean, BEAN_TYPE_MAP.get(key));
                BEAN_OK_MAP.put(key, bean);
                BEAN_TEMP_MAP.remove(key);
            }
            catch (Exception e) {
                Log.error("spring lite autowire fields failed! ", e);
                System.exit(0);
            }
        }
    }

    private static void callAfterPropertiesSet() {
        BEAN_OK_MAP.entrySet().stream().sorted(Comparator.comparing(d -> SpringLiteContext.getOrderByClass(d.getValue().getClass()))).forEach(entry -> {
            Object bean = entry.getValue();
            if (bean instanceof InitializingBean) {
                try {
                    ((InitializingBean)bean).afterPropertiesSet();
                }
                catch (Exception e) {
                    Log.error("spring lite callAfterPropertiesSet fail :  " + bean.getClass(), e);
                    System.exit(0);
                }
            }
        });
    }

    private static void injectionBeanFields(Object obj, Class objType) throws Exception {
        Set<Field> fieldSet = SpringLiteContext.getFieldSet(objType);
        for (Field field : fieldSet) {
            SpringLiteContext.injectionBeanField(obj, field);
        }
    }

    private static Set<Field> getFieldSet(Class objType) {
        HashSet<Field> set = new HashSet<Field>();
        Field[] fields = objType.getDeclaredFields();
        Collections.addAll(set, fields);
        if (!objType.getSuperclass().equals(Object.class)) {
            set.addAll(SpringLiteContext.getFieldSet(objType.getSuperclass()));
        }
        return set;
    }

    private static void injectionBeanField(Object obj, Field field) throws Exception {
        Object value;
        Annotation[] anns = field.getDeclaredAnnotations();
        if (anns == null || anns.length == 0) {
            return;
        }
        Annotation autowired = SpringLiteContext.getFromArray(anns, Autowired.class);
        if (null == autowired) {
            return;
        }
        String name = ((Autowired)autowired).value();
        if (name.trim().length() == 0) {
            Set<String> nameSet = CLASS_NAME_SET_MAP.get(field.getType());
            if (nameSet == null || nameSet.isEmpty()) {
                throw new Exception("Can't find the model,class : " + obj.getClass() + " field:" + field.getName());
            }
            name = nameSet.size() == 1 ? nameSet.iterator().next() : field.getName();
        }
        if (null == (value = SpringLiteContext.getBean(name))) {
            throw new Exception("Can't find the model named:" + name);
        }
        field.setAccessible(true);
        field.set(obj, value);
        field.setAccessible(false);
    }

    private static Object getBean(String name) {
        Object value = BEAN_OK_MAP.get(name);
        if (null == value) {
            value = BEAN_TEMP_MAP.get(name);
        }
        return value;
    }

    public static Object getBeanByClass(String clazzStr) {
        String end;
        if (StringUtils.isBlank(clazzStr)) {
            return null;
        }
        String[] paths = clazzStr.split("\\.");
        if (paths.length == 0) {
            return null;
        }
        String beanName = paths[paths.length - 1];
        String start = beanName.substring(0, 1).toLowerCase();
        String lowerBeanName = start + (end = beanName.substring(1));
        Object value = BEAN_OK_MAP.get(lowerBeanName);
        if (null == value) {
            value = BEAN_TEMP_MAP.get(lowerBeanName);
        }
        return value;
    }

    private static void checkBeanClass(Class clazz) {
        Annotation interceptorAnn;
        Annotation[] anns = clazz.getDeclaredAnnotations();
        if (anns == null || anns.length == 0) {
            return;
        }
        String beanName = null;
        boolean aopProxy = false;
        Annotation ann = SpringLiteContext.getFromArray(anns, Service.class);
        if (null != ann) {
            beanName = ((Service)ann).value();
            aopProxy = true;
        }
        if (null == ann && null != (ann = SpringLiteContext.getFromArray(anns, Component.class))) {
            beanName = ((Component)ann).value();
        }
        if (null == ann && null != (ann = SpringLiteContext.getFromArray(anns, Controller.class))) {
            beanName = ((Controller)ann).value();
        }
        if (null == ann && null != (ann = SpringLiteContext.getFromArray(anns, Configuration.class))) {
            aopProxy = true;
        }
        if (ann != null) {
            if (beanName == null || beanName.trim().length() == 0) {
                beanName = SpringLiteContext.getBeanName(clazz);
            }
            try {
                SpringLiteContext.loadBean(beanName, clazz, aopProxy);
            }
            catch (NulsException e) {
                Log.error("spring lite load bean fail :  " + clazz, e);
                System.exit(0);
                return;
            }
        }
        if (null != (interceptorAnn = SpringLiteContext.getFromArray(anns, Interceptor.class))) {
            BeanMethodInterceptor interceptor;
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                interceptor = (BeanMethodInterceptor)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Log.error("spring lite instance bean fail :  " + clazz, e);
                System.exit(0);
                return;
            }
            BeanMethodInterceptorManager.addBeanMethodInterceptor(((Interceptor)interceptorAnn).value(), interceptor);
        }
    }

    private static String getBeanName(Class clazz) {
        String end;
        String start = clazz.getSimpleName().substring(0, 1).toLowerCase();
        Object beanName = start + (end = clazz.getSimpleName().substring(1));
        if (BEAN_OK_MAP.containsKey(beanName) || BEAN_TEMP_MAP.containsKey(beanName)) {
            beanName = clazz.getName();
        }
        return beanName;
    }

    public static Annotation getFromArray(Annotation[] anns, Class clazz) {
        for (Annotation ann : anns) {
            if (!ann.annotationType().equals(clazz)) continue;
            return ann;
        }
        return null;
    }

    private static void loadBean(String beanName, Class clazz, boolean proxy) throws NulsException {
        Object bean;
        if (BEAN_OK_MAP.containsKey(beanName)) {
            Log.error("model name repetition (" + beanName + "):" + clazz.getName());
        }
        if (BEAN_TEMP_MAP.containsKey(beanName)) {
            Log.error("model name repetition (" + beanName + "):" + clazz.getName());
        }
        if (proxy) {
            bean = SpringLiteContext.createProxy(clazz, interceptor);
        } else {
            try {
                bean = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Log.error(e.getMessage(), e);
                throw new NulsException(e);
            }
        }
        BEAN_TEMP_MAP.put(beanName, bean);
        BEAN_TYPE_MAP.put(beanName, clazz);
        SpringLiteContext.addClassNameMap(clazz, beanName);
    }

    private static Object createProxy(Class clazz, MethodInterceptor interceptor) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)interceptor);
        return enhancer.create();
    }

    private static void addClassNameMap(Class clazz, String beanName) {
        Set nameSet = CLASS_NAME_SET_MAP.computeIfAbsent(clazz, k -> new HashSet());
        nameSet.add(beanName);
        if (null != clazz.getSuperclass() && !clazz.getSuperclass().equals(Object.class)) {
            SpringLiteContext.addClassNameMap(clazz.getSuperclass(), beanName);
        }
        if (clazz.getInterfaces() != null && clazz.getInterfaces().length > 0) {
            for (Class<?> intfClass : clazz.getInterfaces()) {
                SpringLiteContext.addClassNameMap(intfClass, beanName);
            }
        }
    }

    private static int getOrderByClass(Class clazz) {
        List<Annotation> anns = SpringLiteContext.getAnnotationForBean(clazz);
        if (anns.isEmpty()) {
            return 1;
        }
        Optional<Annotation> ann = anns.stream().filter(a -> a.annotationType().equals(Order.class)).findFirst();
        if (ann.isEmpty()) {
            return 1;
        }
        return ((Order)ann.get()).value();
    }

    private static List<Annotation> getAnnotationForBean(Class clazz) {
        Annotation[] anns = clazz.getAnnotations();
        return Arrays.asList(anns);
    }

    public static <T> T getBean(Class<T> beanClass) {
        Set<String> nameSet = CLASS_NAME_SET_MAP.get(beanClass);
        if (null == nameSet || nameSet.isEmpty()) {
            throw new NulsRuntimeException(new Error("can not found " + beanClass + " in beans"));
        }
        if (nameSet.size() > 1) {
            throw new NulsRuntimeException(new Error("find multiple implementations of class " + beanClass + ", try to call getBean with the specifiedBeanName"));
        }
        String beanName = nameSet.iterator().next();
        Object value = BEAN_OK_MAP.get(beanName);
        if (null == value) {
            value = BEAN_TEMP_MAP.get(beanName);
        }
        return (T)value;
    }

    public static void putBean(Class clazz) throws NulsException {
        SpringLiteContext.loadBean(SpringLiteContext.getBeanName(clazz), clazz, true);
        SpringLiteContext.autowireFields();
    }

    public static void putBean(Class clazz, boolean proxy) throws NulsException {
        SpringLiteContext.loadBean(SpringLiteContext.getBeanName(clazz), clazz, proxy);
        SpringLiteContext.autowireFields();
    }

    public static void putBean(String beanName, Object bean) {
        BEAN_TEMP_MAP.put(beanName, bean);
        BEAN_TYPE_MAP.put(beanName, bean.getClass());
        SpringLiteContext.addClassNameMap(bean.getClass(), beanName);
    }

    public static void removeBean(Class clazz) {
        Set<String> nameSet = CLASS_NAME_SET_MAP.get(clazz);
        if (null == nameSet || nameSet.isEmpty()) {
            return;
        }
        for (String name : nameSet) {
            BEAN_OK_MAP.remove(name);
            BEAN_TEMP_MAP.remove(name);
            BEAN_TYPE_MAP.remove(name);
        }
    }

    public static boolean checkBeanOk(Object bean) {
        return BEAN_OK_MAP.containsValue(bean);
    }

    public static <T> List<T> getBeanList(Class<T> beanClass) {
        Set<String> nameSet = CLASS_NAME_SET_MAP.get(beanClass);
        if (null == nameSet || nameSet.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<Object> tlist = new ArrayList<Object>();
        for (String name : nameSet) {
            Object value = BEAN_OK_MAP.get(name);
            if (value == null) {
                value = BEAN_TEMP_MAP.get(name);
            }
            if (null == value) continue;
            tlist.add(value);
        }
        return tlist;
    }

    public static Collection<Object> getAllBeanList() {
        return BEAN_OK_MAP.values();
    }

    public static <T> T getBean(Class<T> beanClass, String specifiedBeanName) {
        Set<String> nameSet = CLASS_NAME_SET_MAP.get(beanClass);
        if (null == nameSet || nameSet.isEmpty() || StringUtils.isBlank(specifiedBeanName)) {
            throw new NulsRuntimeException(new Error("can not found " + beanClass + " in beans"));
        }
        String beanName = null;
        for (String e : nameSet) {
            if (!e.equals(specifiedBeanName)) continue;
            beanName = specifiedBeanName;
        }
        if (beanName == null) {
            throw new NulsRuntimeException(new Error("can't find a instance of the specified class " + beanClass + " with gived name " + specifiedBeanName));
        }
        Object value = BEAN_OK_MAP.get(beanName);
        if (null == value) {
            value = BEAN_TEMP_MAP.get(beanName);
        }
        return (T)value;
    }
}

