/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.crypto;

import io.nuls.core.crypto.HexUtil;
import org.bouncycastle.crypto.digests.SHA3Digest;

public class Sha3Hash {
    public static String sha3(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        try {
            byte[] bytes = HexUtil.decode(src);
            return Sha3Hash.sha3(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String sha3(byte[] bytes) {
        return Sha3Hash.sha3(bytes, 256);
    }

    public static String sha3(byte[] bytes, int bitLength) {
        SHA3Digest digest = new SHA3Digest(bitLength);
        digest.update(bytes, 0, bytes.length);
        byte[] rsData = new byte[digest.getDigestSize()];
        digest.doFinal(rsData, 0);
        return HexUtil.encode(rsData);
    }

    public static byte[] sha3bytes(byte[] bytes, int bitLength) {
        SHA3Digest digest = new SHA3Digest(bitLength);
        digest.update(bytes, 0, bytes.length);
        byte[] rsData = new byte[digest.getDigestSize()];
        digest.doFinal(rsData, 0);
        return rsData;
    }
}

