/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.exception;

import io.nuls.core.constant.ErrorCode;
import java.text.MessageFormat;

public class NulsException
extends Exception {
    private ErrorCode errorCode;
    private String code;
    private String message;

    public NulsException(ErrorCode message) {
        super(message.getMsg());
        this.errorCode = message;
        this.code = message.getCode();
        this.message = message.getMsg();
    }

    public NulsException(ErrorCode errorCode, String message) {
        super(errorCode.getMsg());
        this.code = errorCode.getCode();
        this.message = errorCode.getMsg() + ";" + message;
        this.errorCode = errorCode;
    }

    public NulsException(ErrorCode message, Throwable cause) {
        super(cause);
        this.errorCode = message;
        this.code = message.getCode();
        this.message = message.getMsg();
    }

    public NulsException(Throwable cause) {
        super(cause);
    }

    protected NulsException(ErrorCode message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message.getMsg(), cause, enableSuppression, writableStackTrace);
        this.errorCode = message;
        this.code = message.getCode();
        this.message = message.getMsg();
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getCustomMessage() {
        return this.message;
    }

    public String format() {
        return MessageFormat.format("NulsException -code: [{0}], -msg: {1}", this.code, this.message);
    }
}

