/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.log.logback;

import ch.qos.logback.classic.Logger;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class NulsLogger {
    private Set<String> BASIC_PATH_MAP = new HashSet<String>();
    private String BASIC_PATH = Log.class.getName();
    private Logger logger;

    public NulsLogger(Logger logger) {
        this.logger = logger;
        this.BASIC_PATH_MAP.add(this.BASIC_PATH);
    }

    public void debug(String msg) {
        if (this.logger.isDebugEnabled()) {
            String logContent = this.getLogTrace() + ":" + msg;
            this.logger.debug(logContent);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg, Object ... objs) {
        if (this.logger.isDebugEnabled()) {
            String logContent = this.getLogTrace() + ":" + msg;
            try {
                ArrayList<String> objStrs = new ArrayList<String>();
                for (Object obj : objs) {
                    if (obj instanceof String) {
                        objStrs.add((String)obj);
                        continue;
                    }
                    objStrs.add(JSONUtils.obj2json(obj));
                }
                this.logger.debug(logContent, objStrs.toArray());
            }
            catch (Exception e) {
                Log.error(e);
            }
        }
    }

    public void debug(String msg, Throwable throwable) {
        if (this.logger.isDebugEnabled()) {
            String logContent = this.getLogTrace() + ":" + msg;
            this.logger.debug(logContent, throwable);
        }
    }

    public void info(String msg) {
        String logContent = this.getLogTrace() + ":" + msg;
        this.logger.info(logContent);
    }

    public void info(String msg, Object ... objs) {
        String logContent = this.getLogTrace() + ":" + msg;
        try {
            ArrayList<String> objStrs = new ArrayList<String>();
            for (Object obj : objs) {
                if (obj instanceof String) {
                    objStrs.add((String)obj);
                    continue;
                }
                objStrs.add(JSONUtils.obj2json(obj));
            }
            this.logger.info(logContent, objStrs.toArray());
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public void info(String msg, Throwable throwable) {
        String logContent = this.getLogTrace() + ":" + msg;
        this.logger.info(logContent, throwable);
    }

    public void warn(String msg) {
        String logContent = this.getLogTrace() + ":" + msg;
        this.logger.warn(logContent);
    }

    public void warn(String msg, Object ... objs) {
        String logContent = this.getLogTrace() + ":" + msg;
        try {
            ArrayList<String> objStrs = new ArrayList<String>();
            for (Object obj : objs) {
                if (obj instanceof String) {
                    objStrs.add((String)obj);
                    continue;
                }
                objStrs.add(JSONUtils.obj2json(obj));
            }
            this.logger.warn(logContent, objStrs.toArray());
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public void warn(String msg, Throwable throwable) {
        String logContent = this.getLogTrace() + ":" + msg;
        this.logger.warn(logContent, throwable);
    }

    public void error(String msg) {
        String logContent = this.getLogTrace() + ":" + msg;
        this.logger.error(logContent);
    }

    public void error(String msg, Object ... objs) {
        String logContent = this.getLogTrace() + ":" + msg;
        try {
            ArrayList<Object> objStrs = new ArrayList<Object>();
            for (Object obj : objs) {
                if (obj instanceof String) {
                    objStrs.add((String)obj);
                    continue;
                }
                if (obj instanceof Throwable) {
                    objStrs.add(obj);
                    continue;
                }
                objStrs.add(JSONUtils.obj2json(obj));
            }
            this.logger.error(logContent, objStrs.toArray());
        }
        catch (Exception e) {
            Log.error(e);
        }
    }

    public void error(String msg, Throwable throwable) {
        String logContent = this.getLogTrace() + ":" + msg;
        this.logger.error(logContent, throwable);
    }

    public void error(Throwable throwable) {
        String logContent = this.getLogTrace() + ":";
        this.logger.error(logContent, throwable);
    }

    public void error(String msg, Exception e) {
        String logContent = this.getLogTrace() + ":" + msg;
        if (e instanceof NulsRuntimeException) {
            this.logger.error(logContent + ":" + ((NulsRuntimeException)e).format(), (Throwable)e);
        } else if (e instanceof NulsException) {
            this.logger.error(logContent + ":" + ((NulsException)e).format(), (Throwable)e);
        } else {
            this.logger.error(logContent, (Throwable)e);
        }
    }

    public void error(Exception e) {
        if (e instanceof NulsRuntimeException) {
            this.error((NulsRuntimeException)e);
        } else if (e instanceof NulsException) {
            this.error((NulsException)e);
        } else {
            String logContent = this.getLogTrace() + ":";
            this.logger.error(logContent, (Throwable)e);
        }
    }

    public void error(NulsRuntimeException e) {
        String logContent = this.getLogTrace() + ":" + e.format();
        this.logger.error(logContent, (Throwable)e);
    }

    public void error(NulsException e) {
        String logContent = this.getLogTrace() + ":" + e.format();
        this.logger.error(logContent, (Throwable)e);
    }

    public void trace(String msg) {
        String logContent = this.getLogTrace() + ":" + msg;
        this.logger.trace(logContent);
    }

    public void trace(String msg, Throwable throwable) {
        String logContent = this.getLogTrace() + ":" + msg;
        this.logger.trace(logContent, throwable);
    }

    private String getLogTrace() {
        StringBuilder logTrace = new StringBuilder();
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length > 1) {
            StackTraceElement ste = stack[3];
            if (this.BASIC_PATH_MAP.contains(ste.getClassName())) {
                ste = stack[4];
            }
            if (ste != null) {
                logTrace.append(ste.getClassName());
                logTrace.append('.');
                logTrace.append(ste.getMethodName());
                logTrace.append('(');
                logTrace.append(ste.getFileName());
                logTrace.append(':');
                logTrace.append(ste.getLineNumber());
                logTrace.append(')');
            }
        }
        return logTrace.toString();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void addBasicPath(String basicPath) {
        this.BASIC_PATH_MAP.add(basicPath);
    }
}

