/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.model;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ByteUtils {
    public static final byte[] concatenate(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] t = new byte[length];
        int offset = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, t, offset, array.length);
            offset += array.length;
        }
        return t;
    }

    public static final boolean isEmptyOrNull(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean arrayEquals(byte[] array1, byte[] array2) {
        return Arrays.equals(array1, array2);
    }

    public static byte caculateXor(byte[] data) {
        byte xor = 0;
        if (data == null || data.length == 0) {
            return xor;
        }
        for (int i = 0; i < data.length; ++i) {
            xor = (byte)(xor ^ data[i]);
        }
        return xor;
    }

    public static String asString(byte[] value) {
        return value == null ? null : new String(value, StandardCharsets.UTF_8);
    }

    public static short bytesToShort(byte[] b) {
        return (short)(b[1] << 8 | b[0] & 0xFF);
    }

    public static int bytesToInt(byte[] bytes) {
        int num = 0;
        int temp = 0xFF & bytes[0];
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static long byteToLong(byte[] b) {
        return (long)b[0] & 0xFFL | ((long)b[1] & 0xFFL) << 8 | ((long)b[2] & 0xFFL) << 16 | ((long)b[3] & 0xFFL) << 24 | ((long)b[4] & 0xFFL) << 32 | ((long)b[5] & 0xFFL) << 40 | ((long)b[6] & 0xFFL) << 48 | ((long)b[7] & 0xFFL) << 56;
    }

    public static BigInteger bytesToBigInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[b.length + 1];
            temp[0] = 0;
            System.arraycopy(b, 0, temp, 1, b.length);
            return new BigInteger(temp);
        }
        return new BigInteger(b);
    }

    public static String bytesToString(byte[] bytearray) {
        StringBuilder result = new StringBuilder();
        int length = bytearray.length;
        for (int i = 0; i < length; ++i) {
            char temp = (char)bytearray[i];
            result.append(temp);
        }
        return result.toString();
    }

    public static double bytesToDouble(byte[] arr) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= (long)(arr[i] & 0xFF) << 8 * i;
        }
        return Double.longBitsToDouble(value);
    }

    public static byte[] shortToBytes(short num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num), (byte)(0xFF & num >> 8)};
        return bytes;
    }

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static byte[] longToBytes(long num) {
        int length = 8;
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] doubleToBytes(double d) {
        long value = Double.doubleToRawLongBits(d);
        byte[] byteRet = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byteRet[i] = (byte)(value >> 8 * i & 0xFFL);
        }
        return byteRet;
    }

    public static byte[] subBytes(byte[] input, int startIndex, int length) {
        byte[] bt = new byte[length];
        System.arraycopy(input, startIndex, bt, 0, length);
        return bt;
    }

    public static byte[] reverseBytes(byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buf[i] = bytes[bytes.length - 1 - i];
        }
        return buf;
    }

    public static byte[] copyOf(byte[] in, int length) {
        byte[] out = new byte[length];
        System.arraycopy(in, 0, out, 0, Math.min(length, in.length));
        return out;
    }

    public static String toString(byte[] bytes, String charsetName) {
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toBytes(CharSequence str, String charsetName) {
        try {
            return str.toString().getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean contains(List<byte[]> byteList, byte[] bytes) {
        if (byteList.isEmpty() || bytes == null) {
            return false;
        }
        for (byte[] bytesTemp : byteList) {
            if (!ByteUtils.arrayEquals(bytes, bytesTemp)) continue;
            return true;
        }
        return false;
    }

    public static List<String> bytesToStrings(List<byte[]> byteList) {
        if (byteList.isEmpty()) {
            return null;
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (byte[] bytes : byteList) {
            stringList.add(ByteUtils.asString(bytes));
        }
        return stringList;
    }
}

