/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class CollectionUtils {
    private static final int MAXIMUM_CAPACITY = 0x40000000;

    private static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public static HashMap createHashMap(int cap) {
        int capacity = CollectionUtils.tableSizeFor(cap) << 1;
        return new HashMap(capacity);
    }

    public static LinkedHashMap createLinkedHashMap(int cap) {
        int capacity = CollectionUtils.tableSizeFor(cap) << 1;
        return new LinkedHashMap(capacity);
    }

    public static ConcurrentHashMap createConcurrentHashMap(int cap) {
        int capacity = CollectionUtils.tableSizeFor(cap) << 1;
        return new ConcurrentHashMap(capacity);
    }

    public static HashSet createHashSet(int cap) {
        int capacity = CollectionUtils.tableSizeFor(cap) << 1;
        return new HashSet(capacity);
    }

    public static Set createConcurrentHashSet(int cap) {
        int capacity = CollectionUtils.tableSizeFor(cap) << 1;
        return ConcurrentHashMap.newKeySet(capacity);
    }

    public static String join(List<?> list) {
        if (list == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : list) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(object.toString());
        }
        return sb.toString();
    }

    public static <K, V> Map<K, V> getSynSizedMap(final int size) {
        return Collections.synchronizedMap(new LinkedHashMap<K, V>(size){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > size;
            }
        });
    }

    public static <T> Set<T> getSynSizedSet(final int size) {
        return Collections.synchronizedSet(new TreeSet<T>(){

            @Override
            public boolean add(T t) {
                if (this.size() >= size) {
                    this.pollLast();
                }
                return super.add(t);
            }
        });
    }

    public static <T> List<T> getSynList() {
        return Collections.synchronizedList(new ArrayList());
    }

    public static <T> List<T> removeAll(List<T> source, List<T> destination) {
        LinkedList<T> result = new LinkedList<T>();
        HashSet<T> destinationSet = new HashSet<T>(destination);
        for (T t : source) {
            if (destinationSet.contains(t)) continue;
            result.add(t);
        }
        return result;
    }
}

