/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.model;

import io.nuls.core.model.StringUtils;
import java.nio.charset.StandardCharsets;

public class FormatValidUtils {
    private static final String NULS = "NULS";

    public static boolean validPassword(String password) {
        if (StringUtils.isBlank(password)) {
            return false;
        }
        if (password.length() < 8 || password.length() > 20) {
            return false;
        }
        return password.matches("(.*)[a-zA-Z](.*)") && password.matches("(.*)\\d+(.*)") && !password.matches("(.*)\\s+(.*)") && !password.matches("(.*)[\u4e00-\u9fa5\u3000]+(.*)");
    }

    public static boolean validAlias(String alias) {
        if (StringUtils.isBlank(alias)) {
            return false;
        }
        byte[] aliasBytes = (alias = alias.trim()).getBytes(StandardCharsets.UTF_8);
        if (aliasBytes.length < 1 || aliasBytes.length > 20) {
            return false;
        }
        return alias.matches("^([a-z0-9]+[a-z0-9_]*[a-z0-9]+)|[a-z0-9]+${1,20}");
    }

    public static boolean validTokenNameOrSymbol(String name) {
        if (StringUtils.isBlank(name)) {
            return false;
        }
        String upperCaseName = name.toUpperCase();
        if (upperCaseName.contains(NULS)) {
            return false;
        }
        byte[] aliasBytes = name.getBytes(StandardCharsets.UTF_8);
        if (aliasBytes.length < 1 || aliasBytes.length > 20) {
            return false;
        }
        return name.matches("^([a-zA-Z0-9]+[a-zA-Z0-9_]*[a-zA-Z0-9]+)|[a-zA-Z0-9]+${1,20}");
    }

    public static boolean validTokenNameOrSymbolV15(String name) {
        if (StringUtils.isBlank(name)) {
            return false;
        }
        String upperCaseName = name.toUpperCase();
        if (upperCaseName.equals(NULS)) {
            return false;
        }
        byte[] aliasBytes = name.getBytes(StandardCharsets.UTF_8);
        if (aliasBytes.length < 1 || aliasBytes.length > 20) {
            return false;
        }
        return name.matches("^([a-zA-Z0-9]+[a-zA-Z0-9_]*[a-zA-Z0-9]+)|[a-zA-Z0-9]+${1,20}");
    }

    public static boolean validRemark(String remark) {
        if (null == remark) {
            return true;
        }
        byte[] aliasBytes = (remark = remark.trim()).getBytes(StandardCharsets.UTF_8);
        return aliasBytes.length <= 60;
    }
}

