/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.parse;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JSONUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static ObjectMapper getInstance() {
        return OBJECT_MAPPER;
    }

    public static byte[] obj2ByteArray(Object obj) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsBytes(obj);
    }

    public static String obj2json(Object obj) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    public static String obj2PrettyJson(Object obj) throws JsonProcessingException {
        return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    public static <T> T json2pojo(String jsonStr, Class<T> clazz) throws IOException {
        return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
    }

    public static <T> T byteArray2pojo(byte[] array, Class<T> clazz) throws IOException {
        return (T)OBJECT_MAPPER.readValue(array, clazz);
    }

    public static <T> T json2pojo(String json, Class<T> entityClass, Class ... itemClass) throws IOException {
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(entityClass, itemClass);
        return (T)OBJECT_MAPPER.readValue(json, javaType);
    }

    public static <T> Map<String, Object> json2map(String jsonStr) throws IOException {
        return (Map)OBJECT_MAPPER.readValue(jsonStr, Map.class);
    }

    public static <T> Map<String, T> jsonToMap(String jsonStr) throws IOException {
        return (Map)OBJECT_MAPPER.readValue(jsonStr, Map.class);
    }

    public static <T> Map<String, T> json2map(String jsonStr, Class<T> clazz) throws IOException {
        Map map = (Map)OBJECT_MAPPER.readValue(jsonStr, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
        HashMap<String, T> result = new HashMap<String, T>();
        for (Map.Entry entry : map.entrySet()) {
            result.put((String)entry.getKey(), JSONUtils.map2pojo((Map)entry.getValue(), clazz));
        }
        return result;
    }

    public static <T> List<T> json2list(String jsonArrayStr, Class<T> clazz) throws IOException {
        List list = (List)OBJECT_MAPPER.readValue(jsonArrayStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        ArrayList<T> result = new ArrayList<T>();
        for (Map map : list) {
            result.add(JSONUtils.map2pojo(map, clazz));
        }
        return result;
    }

    public static <T> T map2pojo(Map map, Class<T> clazz) {
        return (T)OBJECT_MAPPER.convertValue((Object)map, clazz);
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new AfterburnerModule());
    }
}

