/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.thread;

import io.nuls.core.log.Log;
import io.nuls.core.thread.commom.NulsThreadFactory;
import io.nuls.core.thread.commom.ThreadCache;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    private static final ThreadCache THREAD_DATA_CACHE = ThreadCache.getInstance();
    private static final String TEMPORARY_THREAD_POOL_NAME = "temporary";
    private static final int TEMPORARY_THREAD_POOL_COUNT = 4;
    private static final int TEMPORARY_THREAD_POOL_QUEUE_SIZE = 1000;
    private static final ThreadPoolExecutor TEMPORARY_THREAD_POOL = ThreadUtils.createThreadPool(4, 1000, new NulsThreadFactory("temporary"));

    public static final void putThread(String poolName, String threadName, Thread newThread) {
        THREAD_DATA_CACHE.putThread(poolName, threadName, newThread);
    }

    public static final ThreadPoolExecutor createThreadPool(int threadCount, int queueSize, NulsThreadFactory factory) {
        if (threadCount == 0) {
            throw new RuntimeException("thread count cannot be 0!");
        }
        if (factory == null) {
            throw new RuntimeException("thread factory cannot be null!");
        }
        LinkedBlockingQueue<Runnable> queue = queueSize > 0 ? new LinkedBlockingQueue(queueSize) : new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, queue, factory);
        THREAD_DATA_CACHE.putPool(factory.getPoolName(), pool);
        return pool;
    }

    public static final ScheduledThreadPoolExecutor createScheduledThreadPool(int threadCount, NulsThreadFactory factory) {
        if (factory == null) {
            throw new RuntimeException("thread factory cannot be null!");
        }
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(threadCount, factory);
        THREAD_DATA_CACHE.putPool(factory.getPoolName(), pool);
        return pool;
    }

    public static final ScheduledThreadPoolExecutor createScheduledThreadPool(NulsThreadFactory factory) {
        return ThreadUtils.createScheduledThreadPool(1, factory);
    }

    public static final <V> Future<V> asynExecuteCallable(Callable<V> callable) {
        if (null == callable) {
            throw new RuntimeException("runnable is null");
        }
        if (TEMPORARY_THREAD_POOL == null) {
            throw new RuntimeException("temporary thread pool not initialized yet");
        }
        BlockingQueue<Runnable> blockingQueue = TEMPORARY_THREAD_POOL.getQueue();
        if (blockingQueue.size() > 200) {
            Log.info("Task Queue 100 Size Warning!!! Task info is " + callable.toString());
        }
        Future<V> future = TEMPORARY_THREAD_POOL.submit(callable);
        int i = TEMPORARY_THREAD_POOL.getQueue().size();
        if (i > 10) {
            System.out.println("thread pool size:" + i);
        }
        return future;
    }

    public static final void asynExecuteRunnable(Runnable runnable) {
        if (null == runnable) {
            throw new RuntimeException("runnable is null");
        }
        if (TEMPORARY_THREAD_POOL == null) {
            throw new RuntimeException("temporary thread pool not initialized yet");
        }
        BlockingQueue<Runnable> blockingQueue = TEMPORARY_THREAD_POOL.getQueue();
        if (blockingQueue.size() > 200) {
            Log.info("Task Queue 100 Size Warning!!! Task info is " + runnable.toString());
        }
        TEMPORARY_THREAD_POOL.execute(runnable);
        int i = TEMPORARY_THREAD_POOL.getQueue().size();
        if (i > 10) {
            System.out.println("thread pool size:" + i);
        }
    }

    public static final void createAndRunThread(String threadName, Runnable runnable) {
        ThreadUtils.createAndRunThread(threadName, runnable, true);
    }

    public static final void createAndRunThread(String threadName, Runnable runnable, boolean deamon) {
        NulsThreadFactory factory = new NulsThreadFactory(threadName);
        Thread thread = factory.newThread(runnable);
        thread.setDaemon(deamon);
        thread.start();
    }

    public static final List<Thread> getThreadList() {
        return THREAD_DATA_CACHE.getThreadList();
    }

    public static Thread getThread(String threadName) {
        return THREAD_DATA_CACHE.getThread(threadName);
    }

    public static List<Thread> getPoolThread(String poolName) {
        return THREAD_DATA_CACHE.getThreadList(poolName);
    }

    public static void stopAllThread() {
        List<ThreadPoolExecutor> poolList = THREAD_DATA_CACHE.getPoolList();
        for (ThreadPoolExecutor pool : poolList) {
            pool.shutdown();
        }
        List<Thread> threadList = THREAD_DATA_CACHE.getThreadList();
        if (threadList.size() > 0) {
            for (Thread thread : threadList) {
                if (thread.getState() != Thread.State.RUNNABLE) continue;
                thread.interrupt();
            }
        }
        THREAD_DATA_CACHE.removeAllThread();
    }

    public static void stopThread(String threadName) {
        Thread thread = THREAD_DATA_CACHE.getThread(threadName);
        if (thread.getState() == Thread.State.RUNNABLE) {
            thread.interrupt();
        }
        THREAD_DATA_CACHE.removeThread(threadName);
    }
}

