/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.config;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import io.nuls.core.core.annotation.Controller;
import io.nuls.core.core.annotation.RpcMethod;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.provider.api.filter.RpcServerFilter;
import io.nuls.provider.api.jsonrpc.JsonRpcContext;
import io.nuls.provider.api.jsonrpc.RpcMethodInvoker;
import io.nuls.provider.utils.Log;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.ws.rs.Path;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class NulsResourceConfig
extends ResourceConfig {
    public NulsResourceConfig() {
        this.register(MultiPartFeature.class);
        this.register(RpcServerFilter.class);
        this.register(JacksonJsonProvider.class);
        Collection list = SpringLiteContext.getAllBeanList();
        for (Object object : list) {
            if (object.getClass().getAnnotation(Path.class) != null) {
                Log.debug("register restFul resource:{}", object.getClass());
                this.register(object);
            }
            this.initJsonRpcMethodHandlers(object);
        }
    }

    private void initJsonRpcMethodHandlers(Object bean) {
        Annotation anno = SpringLiteContext.getFromArray((Annotation[])bean.getClass().getDeclaredAnnotations(), Controller.class);
        if (null == anno) {
            return;
        }
        Method[] methods = bean.getClass().getDeclaredMethods();
        if (null == methods || methods.length == 0) {
            return;
        }
        for (Method method : methods) {
            RpcMethod rpc = (RpcMethod)SpringLiteContext.getFromArray((Annotation[])method.getDeclaredAnnotations(), RpcMethod.class);
            if (null == rpc) continue;
            String methodCmd = rpc.value();
            if (methodCmd == null || methodCmd.trim().length() == 0) {
                Log.warn("null method:" + bean.getClass() + ":" + method.getName());
                continue;
            }
            JsonRpcContext.RPC_METHOD_INVOKER_MAP.put(methodCmd, new RpcMethodInvoker(bean, method));
        }
    }
}

