/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.jsonrpc.controller;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.crosschain.ChainManageProvider;
import io.nuls.base.api.provider.crosschain.facade.CrossAssetRegisterInfo;
import io.nuls.base.api.provider.crosschain.facade.GetCrossAssetInfoReq;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Controller;
import io.nuls.core.core.annotation.RpcMethod;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.api.config.Context;
import io.nuls.provider.model.jsonrpc.RpcResult;
import io.nuls.provider.rpctools.BlockTools;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.provider.utils.VerifyUtils;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.annotation.ApiType;
import java.util.List;
import java.util.Map;

@Controller
@Api(type=ApiType.JSONRPC)
public class ChainController {
    ChainManageProvider chainManageProvider = (ChainManageProvider)ServiceManager.get(ChainManageProvider.class);
    @Autowired
    private Config config;
    @Autowired
    BlockTools blockTools;

    @RpcMethod(value="info")
    @ApiOperation(description="Obtain information related to this chain,Among them, consensus assets are the assets required for creating consensus node transactions and creating delegated consensus transactions in this chain", order=1)
    @ResponseData(name="Return value", description="Return this chain information", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="chainId", description="This chain'sID"), @Key(name="assetId", description="This chain defaults to the main asset'sID"), @Key(name="inflationAmount", description="The initial quantity of the default main asset in this chain"), @Key(name="agentChainId", description="The chain of consensus assets in this chainID"), @Key(name="agentAssetId", description="The consensus assets of this chainID"), @Key(name="addressPrefix", description="Prefix for this chain address"), @Key(name="symbol", description="Main asset symbol of this chain")}))
    public RpcResult getInfo(List<Object> params) {
        Result<Map> result = this.blockTools.getInfo(this.config.getChainId());
        if (result.isSuccess()) {
            Map map = (Map)result.getData();
            map.put("chainId", this.config.getChainId());
            map.put("assetId", this.config.getAssetsId());
            map.put("addressPrefix", this.config.getAddressPrefix());
            map.put("symbol", this.config.getSymbol());
            map.remove("awardAssetId");
            map.remove("seedNodes");
        }
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="assetsInfo")
    public RpcResult getAssetsInfo(List<Object> params) {
        if (Context.isRunCrossChain) {
            return RpcResult.success(Context.assetList);
        }
        return RpcResult.success(Context.defaultChain.getAssets());
    }

    @RpcMethod(value="getCrossAssetInfo")
    @ApiOperation(description="Obtain parallel chain asset information", order=603)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="Asset ChainID"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="assetID")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=CrossAssetRegisterInfo.class))
    public RpcResult getCrossAssetInfo(List<Object> params) {
        int assetId;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is invalid");
        }
        try {
            assetId = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[assetId] is invalid");
        }
        Result result = this.chainManageProvider.getCrossAssetInfo(new GetCrossAssetInfoReq(Integer.valueOf(chainId), Integer.valueOf(assetId)));
        return ResultUtil.getJsonRpcResult(result);
    }
}

