/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.resources;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.block.BlockService;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHashReq;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHeightReq;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByLastHeightReq;
import io.nuls.base.data.Block;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.api.config.Context;
import io.nuls.provider.api.manager.BeanCopierManager;
import io.nuls.provider.model.ErrorData;
import io.nuls.provider.model.RpcClientResult;
import io.nuls.provider.model.dto.block.BlockDto;
import io.nuls.provider.model.dto.block.BlockHeaderDto;
import io.nuls.provider.rpctools.BlockTools;
import io.nuls.provider.utils.Log;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.util.ValidateUtil;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/api/block")
@Component
@Api
public class BlockResource {
    BlockService blockService = (BlockService)ServiceManager.get(BlockService.class);
    @Autowired
    private Config config;
    @Autowired
    BlockTools blockTools;

    @GET
    @Path(value="/header/height/{height}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Query block headers based on block height", order=201)
    @Parameters(value={@Parameter(parameterName="height", requestType=@TypeDescriptor(value=Long.class), parameterDes="block height")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public RpcClientResult getBlockHeaderByHeight(@PathParam(value="height") Long height) {
        if (height == null || height < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "height is invalid"));
        }
        GetBlockHeaderByHeightReq req = new GetBlockHeaderByHeightReq(height);
        req.setChainId(this.config.getChainId());
        Result result = this.blockService.getBlockHeaderByHeight(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess() && clientResult.getData() != null) {
            BlockHeaderDto dto = new BlockHeaderDto();
            Object data = clientResult.getData();
            BeanCopierManager.beanCopier(data, dto);
            clientResult.setData(dto);
        }
        return clientResult;
    }

    @GET
    @Path(value="/header/hash/{hash}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Based on blockshashQuery block header", order=202)
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="blockhash")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public RpcClientResult getBlockHeaderByHash(@PathParam(value="hash") String hash) {
        if (hash == null || !ValidateUtil.validHash((String)hash)) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "hash is invalid"));
        }
        GetBlockHeaderByHashReq req = new GetBlockHeaderByHashReq(hash);
        req.setChainId(this.config.getChainId());
        Result result = this.blockService.getBlockHeaderByHash(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess() && clientResult.getData() != null) {
            BlockHeaderDto dto = new BlockHeaderDto();
            Object data = clientResult.getData();
            BeanCopierManager.beanCopier(data, dto);
            clientResult.setData(dto);
        }
        return clientResult;
    }

    @GET
    @Path(value="/header/newest")
    @Produces(value={"application/json"})
    @ApiOperation(description="Query the latest block header information", order=203)
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public RpcClientResult getBestBlockHeader() {
        GetBlockHeaderByLastHeightReq req = new GetBlockHeaderByLastHeightReq();
        req.setChainId(this.config.getChainId());
        Result result = this.blockService.getBlockHeaderByLastHeight(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            BlockHeaderDto dto = new BlockHeaderDto();
            Object data = clientResult.getData();
            BeanCopierManager.beanCopier(data, dto);
            clientResult.setData(dto);
        }
        return clientResult;
    }

    @GET
    @Path(value="/newest")
    @Produces(value={"application/json"})
    @ApiOperation(description="Query the latest block", order=204, detailDesc="This interface contains all transaction information packaged in blocks. It returns a large amount of data and should be called with caution")
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockDto.class))
    public RpcClientResult getBestBlock() {
        Result<Block> result = this.blockTools.getBestBlock(Context.getChainId());
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            try {
                clientResult.setData(new BlockDto((Block)clientResult.getData()));
            }
            catch (NulsException e) {
                Log.error(e);
                return ResultUtil.getNulsExceptionRpcClientResult(e);
            }
        }
        return clientResult;
    }

    @GET
    @Path(value="/height/{height}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Query blocks based on block height", order=205, detailDesc="This interface contains all transaction information packaged in blocks. It returns a large amount of data and should be called with caution")
    @Parameters(value={@Parameter(parameterName="height", requestType=@TypeDescriptor(value=Long.class), parameterDes="block height")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockDto.class))
    public RpcClientResult getBlockByHeight(@PathParam(value="height") Long height) {
        if (height == null || height < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "height is invalid"));
        }
        Result<Block> result = this.blockTools.getBlockByHeight(this.config.getChainId(), height);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            try {
                if (clientResult.getData() != null) {
                    clientResult.setData(new BlockDto((Block)clientResult.getData()));
                }
            }
            catch (NulsException e) {
                Log.error(e);
                return ResultUtil.getNulsExceptionRpcClientResult(e);
            }
        }
        return clientResult;
    }

    @GET
    @Path(value="/hash/{hash}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Based on blockshashQuery Block", order=206, detailDesc="This interface contains all transaction information packaged in blocks. It returns a large amount of data and should be called with caution")
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="blockhash")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockDto.class))
    public RpcClientResult getBlockByHash(@PathParam(value="hash") String hash) {
        if (hash == null || !ValidateUtil.validHash((String)hash)) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "hash is invalid"));
        }
        Result<Block> result = this.blockTools.getBlockByHash(this.config.getChainId(), hash);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            try {
                if (clientResult.getData() != null) {
                    clientResult.setData(new BlockDto((Block)clientResult.getData()));
                }
            }
            catch (NulsException e) {
                Log.error(e);
                return ResultUtil.getNulsExceptionRpcClientResult(e);
            }
        }
        return clientResult;
    }

    @GET
    @Path(value="/serialization/height/{height}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Query block serialization strings based on block height", order=207, detailDesc="This interface contains all transaction information packaged in blocks. It returns a large amount of data and should be called with caution")
    @Parameters(value={@Parameter(parameterName="height", requestType=@TypeDescriptor(value=Long.class), parameterDes="block height")})
    @ResponseData(name="Return value", description="Return the serialized blockHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public RpcClientResult getBlockSerializationByHeight(@PathParam(value="height") Long height) {
        if (height == null || height < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "height is invalid"));
        }
        Result<String> result = this.blockTools.getBlockSerializationByHeight(this.config.getChainId(), height);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        return clientResult;
    }

    @GET
    @Path(value="/serialization/hash/{hash}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Based on blockshashQuery block serialization string", order=208, detailDesc="This interface contains all transaction information packaged in blocks. It returns a large amount of data and should be called with caution")
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="blockhash")})
    @ResponseData(name="Return value", description="Return the serialized blockHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public RpcClientResult getBlockSerializationByHash(@PathParam(value="hash") String hash) {
        if (hash == null || !ValidateUtil.validHash((String)hash)) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "hash is invalid"));
        }
        Result<String> result = this.blockTools.getBlockSerializationByHash(this.config.getChainId(), hash);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        return clientResult;
    }
}

