/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.resources;

import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.contract.ContractProvider;
import io.nuls.base.api.provider.contract.facade.CreateContractReq;
import io.nuls.base.api.provider.contract.facade.DeleteContractReq;
import io.nuls.base.api.provider.contract.facade.TokenTransferReq;
import io.nuls.base.api.provider.contract.facade.TransferToContractReq;
import io.nuls.base.basic.AddressTool;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.model.ErrorData;
import io.nuls.provider.model.RpcClientResult;
import io.nuls.provider.model.dto.ContractConstructorInfoDto;
import io.nuls.provider.model.dto.ContractInfoDto;
import io.nuls.provider.model.dto.ContractResultDto;
import io.nuls.provider.model.dto.ContractTokenInfoDto;
import io.nuls.provider.model.dto.ContractTransactionDto;
import io.nuls.provider.model.dto.ProgramMethod;
import io.nuls.provider.model.form.contract.ContractCall;
import io.nuls.provider.model.form.contract.ContractCallOffline;
import io.nuls.provider.model.form.contract.ContractCode;
import io.nuls.provider.model.form.contract.ContractComputeAddress;
import io.nuls.provider.model.form.contract.ContractCreate;
import io.nuls.provider.model.form.contract.ContractCreateOffline;
import io.nuls.provider.model.form.contract.ContractDelete;
import io.nuls.provider.model.form.contract.ContractDeleteOffline;
import io.nuls.provider.model.form.contract.ContractMethodForm;
import io.nuls.provider.model.form.contract.ContractResultListForm;
import io.nuls.provider.model.form.contract.ContractTokenTransfer;
import io.nuls.provider.model.form.contract.ContractTokenTransferOffline;
import io.nuls.provider.model.form.contract.ContractTransfer;
import io.nuls.provider.model.form.contract.ContractTransferOffline;
import io.nuls.provider.model.form.contract.ContractValidateCall;
import io.nuls.provider.model.form.contract.ContractValidateCreate;
import io.nuls.provider.model.form.contract.ContractValidateDelete;
import io.nuls.provider.model.form.contract.ContractViewCall;
import io.nuls.provider.model.form.contract.ImputedGasContractCall;
import io.nuls.provider.model.form.contract.ImputedGasContractCreate;
import io.nuls.provider.rpctools.ContractTools;
import io.nuls.provider.utils.Log;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.provider.utils.Utils;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.util.NulsSDKTool;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/api/contract")
@Component
@Api
public class ContractResource {
    ContractProvider contractProvider = (ContractProvider)ServiceManager.get(ContractProvider.class);
    @Autowired
    ContractTools contractTools;
    @Autowired
    Config config;

    @POST
    @Path(value="/create")
    @Produces(value={"application/json"})
    @ApiOperation(description="Publish contract", order=401)
    @Parameters(value={@Parameter(parameterName="Publish contract", parameterDes="Publish Contract Form", requestType=@TypeDescriptor(value=ContractCreate.class))})
    @ResponseData(name="Return value", description="Return aMapObject, containing two properties", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="Transactions for publishing contractshash"), @Key(name="contractAddress", description="Generated contract address")}))
    public RpcClientResult createContract(ContractCreate create) {
        if (create == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        if (create.getGasLimit() < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), String.format("gasLimit [%s] is invalid", create.getGasLimit())));
        }
        if (create.getPrice() < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), String.format("price [%s] is invalid", create.getPrice())));
        }
        CreateContractReq req = new CreateContractReq();
        req.setChainId(this.config.getChainId());
        req.setSender(create.getSender());
        req.setPassword(create.getPassword());
        req.setPrice(create.getPrice());
        req.setGasLimit(create.getGasLimit());
        req.setContractCode(create.getContractCode());
        req.setAlias(create.getAlias());
        req.setArgs(create.getArgs());
        req.setRemark(create.getRemark());
        io.nuls.base.api.provider.Result result = this.contractProvider.createContract(req);
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/call")
    @Produces(value={"application/json"})
    @ApiOperation(description="Call Contract", order=402)
    @Parameters(value={@Parameter(parameterName="Call Contract", parameterDes="Call Contract Form", requestType=@TypeDescriptor(value=ContractCall.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="Transaction calling contracthash")}))
    public RpcClientResult callContract(ContractCall call) {
        if (call == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        if (call.getValue() == null || call.getValue().compareTo(BigInteger.ZERO) < 0) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "value is invalid"));
        }
        if (call.getGasLimit() < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), String.format("gasLimit [%s] is invalid", call.getGasLimit())));
        }
        if (call.getPrice() < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), String.format("price [%s] is invalid", call.getPrice())));
        }
        io.nuls.base.api.provider.Result<Map> mapResult = this.contractTools.contractCall(this.config.getChainId(), call.getSender(), call.getPassword(), call.getValue(), call.getGasLimit(), call.getPrice(), call.getContractAddress(), call.getMethodName(), call.getMethodDesc(), call.getArgs(), call.getRemark(), call.getMultyAssetValues());
        return ResultUtil.getRpcClientResult(mapResult);
    }

    @POST
    @Path(value="/delete")
    @Produces(value={"application/json"})
    @ApiOperation(description="Delete contract", order=403)
    @Parameters(value={@Parameter(parameterName="Delete contract", parameterDes="Delete Contract Form", requestType=@TypeDescriptor(value=ContractDelete.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="Delete transactions for contractshash")}))
    public RpcClientResult deleteContract(ContractDelete delete) {
        if (delete == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        DeleteContractReq req = new DeleteContractReq(delete.getSender(), delete.getContractAddress(), delete.getPassword());
        req.setChainId(this.config.getChainId());
        req.setRemark(delete.getRemark());
        io.nuls.base.api.provider.Result result = this.contractProvider.deleteContract(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("txHash", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/tokentransfer")
    @Produces(value={"application/json"})
    @ApiOperation(description="contracttokenTransfer", order=404)
    @Parameters(value={@Parameter(parameterName="tokenTransfer", parameterDes="tokenTransfer Form", requestType=@TypeDescriptor(value=ContractTokenTransfer.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="transactionhash")}))
    public RpcClientResult tokentransfer(ContractTokenTransfer form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        if (form.getAmount() == null || form.getAmount().compareTo(BigInteger.ZERO) < 0) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "amount is invalid"));
        }
        TokenTransferReq req = new TokenTransferReq();
        req.setChainId(this.config.getChainId());
        req.setAddress(form.getFromAddress());
        req.setPassword(form.getPassword());
        req.setToAddress(form.getToAddress());
        req.setContractAddress(form.getContractAddress());
        req.setAmount(form.getAmount().toString());
        req.setRemark(form.getRemark());
        io.nuls.base.api.provider.Result result = this.contractProvider.tokenTransfer(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("txHash", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/transfer2contract")
    @Produces(value={"application/json"})
    @ApiOperation(description="Transfer from account address to contract address(Main chain assets)Contract transactions", order=405)
    @Parameters(value={@Parameter(parameterName="Transfer to the contracted address", parameterDes="Transfer Form to Contract Address", requestType=@TypeDescriptor(value=ContractTransfer.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="transactionhash")}))
    public RpcClientResult transferTocontract(ContractTransfer form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        if (form.getAmount() == null || form.getAmount().compareTo(BigInteger.ZERO) < 0) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "amount is invalid"));
        }
        TransferToContractReq req = new TransferToContractReq(form.getFromAddress(), form.getToAddress(), form.getAmount(), form.getPassword(), form.getRemark());
        req.setChainId(this.config.getChainId());
        io.nuls.base.api.provider.Result result = this.contractProvider.transferToContract(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("txHash", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @GET
    @Path(value="/balance/token/{contractAddress}/{address}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Obtain the specified contract for the account addresstokenbalance", order=406)
    @Parameters(value={@Parameter(parameterName="contractAddress", parameterDes="Contract address"), @Parameter(parameterName="address", parameterDes="Account address")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=ContractTokenInfoDto.class))
    public RpcClientResult getTokenBalance(@PathParam(value="contractAddress") String contractAddress, @PathParam(value="address") String address) {
        if (address == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "address is empty"));
        }
        io.nuls.base.api.provider.Result<ContractTokenInfoDto> result = this.contractTools.getTokenBalance(this.config.getChainId(), contractAddress, address);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        return clientResult;
    }

    @GET
    @Path(value="/info/{address}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Get detailed information about smart contracts", order=407)
    @Parameters(value={@Parameter(parameterName="address", parameterDes="Contract address")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=ContractInfoDto.class))
    public RpcClientResult getContractDetailInfo(@PathParam(value="address") String address) {
        if (address == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "address is empty"));
        }
        io.nuls.base.api.provider.Result<Map> result = this.contractTools.getContractInfo(this.config.getChainId(), address);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        return clientResult;
    }

    @GET
    @Path(value="/result/{hash}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Obtain the execution results of smart contracts", order=408)
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="transactionhash")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=ContractResultDto.class))
    public RpcClientResult getContractResult(@PathParam(value="hash") String hash) {
        if (hash == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "hash is empty"));
        }
        io.nuls.base.api.provider.Result<Map> result = this.contractTools.getContractResult(this.config.getChainId(), hash);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        return clientResult;
    }

    @POST
    @Path(value="/result/list")
    @Produces(value={"application/json"})
    @ApiOperation(description="Obtain a list of smart contract execution results", order=409)
    @Parameters(value={@Parameter(parameterName="Obtain a list of smart contract execution results", parameterDes="Get the smart contract execution result list form", requestType=@TypeDescriptor(value=ContractResultListForm.class))})
    @ResponseData(name="Return value", description="Return the list of contract execution results for the transaction", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash1 or hash2 or hash3...", valueType=ContractResultDto.class, description="TradinghashIn the listhashValue askeyHerekey nameIt is dynamic")}))
    public RpcClientResult getContractResultList(ContractResultListForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        io.nuls.base.api.provider.Result<Map> result = this.contractTools.getContractResultList(this.config.getChainId(), form.getHashList());
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        return clientResult;
    }

    @POST
    @Path(value="/constructor")
    @Produces(value={"application/json"})
    @ApiOperation(description="Get contract code constructor", order=410)
    @Parameters(value={@Parameter(parameterName="Get contract code constructor", parameterDes="Get Contract Code Constructor Form", requestType=@TypeDescriptor(value=ContractCode.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=ContractConstructorInfoDto.class))
    public RpcClientResult getContractConstructor(ContractCode form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        io.nuls.base.api.provider.Result<Map> result = this.contractTools.getContractConstructor(this.config.getChainId(), form.getContractCode());
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        return clientResult;
    }

    @POST
    @Path(value="/method")
    @Produces(value={"application/json"})
    @ApiOperation(description="Obtain information on the specified function of the published contract", order=411)
    @Parameters(value={@Parameter(parameterName="Obtain information on the specified function of the published contract", parameterDes="Get the information form for the specified function of the published contract", requestType=@TypeDescriptor(value=ContractMethodForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=ProgramMethod.class))
    public RpcClientResult getContractMethod(ContractMethodForm form) {
        int chainId = this.config.getChainId();
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        if (!AddressTool.validAddress((int)chainId, (String)form.getContractAddress())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), String.format("contractAddress [%s] is invalid", form.getContractAddress())));
        }
        if (StringUtils.isBlank((String)form.getMethodName())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "methodName is empty"));
        }
        io.nuls.base.api.provider.Result<Map> contractInfoDtoResult = this.contractTools.getContractInfo(chainId, form.getContractAddress());
        if (contractInfoDtoResult.isFailed()) {
            return ResultUtil.getRpcClientResult(contractInfoDtoResult);
        }
        Map contractInfo = (Map)contractInfoDtoResult.getData();
        String methodName = form.getMethodName();
        String methodDesc = form.getMethodDesc();
        List methods = (List)contractInfo.get("method");
        Map resultMethod = null;
        boolean isEmptyMethodDesc = StringUtils.isBlank((String)methodDesc);
        for (Map method : methods) {
            if (!methodName.equals(method.get("name"))) continue;
            if (isEmptyMethodDesc) {
                resultMethod = method;
                break;
            }
            if (!methodDesc.equals(method.get("desc"))) continue;
            resultMethod = method;
            break;
        }
        if (resultMethod == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.DATA_NOT_FOUND));
        }
        return RpcClientResult.getSuccess(resultMethod);
    }

    @POST
    @Path(value="/method/argstypes")
    @Produces(value={"application/json"})
    @ApiOperation(description="Get a list of parameter types for specified functions in published contracts", order=412)
    @Parameters(value={@Parameter(parameterName="Get a list of parameter types for specified functions in published contracts", parameterDes="Get the parameter type form for the function specified in the published contract", requestType=@TypeDescriptor(value=ContractMethodForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public RpcClientResult getContractMethodArgsTypes(ContractMethodForm form) {
        RpcClientResult clientResult = this.getContractMethod(form);
        if (clientResult.isFailed()) {
            return clientResult;
        }
        Map resultMethod = (Map)clientResult.getData();
        if (resultMethod == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.DATA_NOT_FOUND));
        }
        try {
            List args = (List)resultMethod.get("args");
            ArrayList<String> argsTypes = new ArrayList<String>();
            for (Map arg : args) {
                argsTypes.add((String)arg.get("type"));
            }
            return RpcClientResult.getSuccess(argsTypes);
        }
        catch (Exception e) {
            Log.error(e);
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.DATA_ERROR.getCode(), e.getMessage()));
        }
    }

    @POST
    @Path(value="/validate/create")
    @Produces(value={"application/json"})
    @ApiOperation(description="Verify release contract", order=413)
    @Parameters(value={@Parameter(parameterName="Verify release contract", parameterDes="Verify and publish the contract form", requestType=@TypeDescriptor(value=ContractValidateCreate.class))})
    @ResponseData(name="Return value", description="Return consumedgasvalue", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="success", valueType=boolean.class, description="Verification success or failure"), @Key(name="code", description="Error code for verification failure"), @Key(name="msg", description="Error message for verification failure")}))
    public RpcClientResult validateContractCreate(ContractValidateCreate form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        if (form.getGasLimit() < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), String.format("gasLimit [%s] is invalid", form.getGasLimit())));
        }
        if (form.getPrice() < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), String.format("price [%s] is invalid", form.getPrice())));
        }
        io.nuls.base.api.provider.Result<Map> mapResult = this.contractTools.validateContractCreate(this.config.getChainId(), form.getSender(), form.getGasLimit(), form.getPrice(), form.getContractCode(), form.getArgs());
        return ResultUtil.getRpcClientResult(mapResult);
    }

    @POST
    @Path(value="/validate/call")
    @Produces(value={"application/json"})
    @ApiOperation(description="Verify Call Contract", order=414)
    @Parameters(value={@Parameter(parameterName="Verify Call Contract", parameterDes="Verify Call Contract Form", requestType=@TypeDescriptor(value=ContractValidateCall.class))})
    @ResponseData(name="Return value", description="Return consumedgasvalue", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="success", valueType=boolean.class, description="Verification success or failure"), @Key(name="code", description="Error code for verification failure"), @Key(name="msg", description="Error message for verification failure")}))
    public RpcClientResult validateContractCall(ContractValidateCall form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        if (form.getGasLimit() < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), String.format("gasLimit [%s] is invalid", form.getGasLimit())));
        }
        if (form.getPrice() < 0L) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), String.format("price [%s] is invalid", form.getPrice())));
        }
        io.nuls.base.api.provider.Result<Map> mapResult = this.contractTools.validateContractCall(this.config.getChainId(), form.getSender(), form.getValue(), form.getGasLimit(), form.getPrice(), form.getContractAddress(), form.getMethodName(), form.getMethodDesc(), form.getArgs(), form.getMultyAssetValues());
        return ResultUtil.getRpcClientResult(mapResult);
    }

    @POST
    @Path(value="/validate/delete")
    @Produces(value={"application/json"})
    @ApiOperation(description="Verify deletion of contract", order=415)
    @Parameters(value={@Parameter(parameterName="Verify deletion of contract", parameterDes="Verify Delete Contract Form", requestType=@TypeDescriptor(value=ContractValidateDelete.class))})
    @ResponseData(name="Return value", description="Return consumedgasvalue", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="success", valueType=boolean.class, description="Verification success or failure"), @Key(name="code", description="Error code for verification failure"), @Key(name="msg", description="Error message for verification failure")}))
    public RpcClientResult validateContractDelete(ContractValidateDelete form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        io.nuls.base.api.provider.Result<Map> mapResult = this.contractTools.validateContractDelete(this.config.getChainId(), form.getSender(), form.getContractAddress());
        return ResultUtil.getRpcClientResult(mapResult);
    }

    @POST
    @Path(value="/imputedgas/create")
    @Produces(value={"application/json"})
    @ApiOperation(description="Estimate the release of contract transactionsGAS", order=416)
    @Parameters(value={@Parameter(parameterName="Estimate the release of contract transactionsGAS", parameterDes="Estimate the release of contract transactionsGASform", requestType=@TypeDescriptor(value=ImputedGasContractCreate.class))})
    @ResponseData(name="Return value", description="Return consumedgasvalue", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="gasLimit", valueType=Long.class, description="ConsumablegasValue, return value for execution failure1")}))
    public RpcClientResult imputedContractCreateGas(ImputedGasContractCreate form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        io.nuls.base.api.provider.Result<Map> mapResult = this.contractTools.imputedContractCreateGas(this.config.getChainId(), form.getSender(), form.getContractCode(), form.getArgs());
        return ResultUtil.getRpcClientResult(mapResult);
    }

    @POST
    @Path(value="/imputedgas/call")
    @Produces(value={"application/json"})
    @ApiOperation(description="Estimating the call to contract transactionsGAS", order=417)
    @Parameters(value={@Parameter(parameterName="Estimating the call to contract transactionsGAS", parameterDes="Estimating the call to contract transactionsGASform", requestType=@TypeDescriptor(value=ImputedGasContractCall.class))})
    @ResponseData(name="Return value", description="Return consumedgasvalue", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="gasLimit", valueType=Long.class, description="ConsumablegasValue, return value for execution failure1")}))
    public RpcClientResult imputedContractCallGas(ImputedGasContractCall form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        io.nuls.base.api.provider.Result<Map> mapResult = this.contractTools.imputedContractCallGas(this.config.getChainId(), form.getSender(), form.getValue(), form.getContractAddress(), form.getMethodName(), form.getMethodDesc(), form.getArgs(), form.getMultyAssetValues());
        return ResultUtil.getRpcClientResult(mapResult);
    }

    @POST
    @Path(value="/view")
    @Produces(value={"application/json"})
    @ApiOperation(description="Call the contract not on chain method", order=418)
    @Parameters(value={@Parameter(parameterName="Call the contract not on chain method", parameterDes="Call contract non chain method form", requestType=@TypeDescriptor(value=ContractViewCall.class))})
    @ResponseData(name="Return value", description="returnMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="result", description="The call result of the view method")}))
    public RpcClientResult invokeView(ContractViewCall form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        io.nuls.base.api.provider.Result<Map> mapResult = this.contractTools.invokeView(this.config.getChainId(), form.getHeight() == null ? 0L : form.getHeight(), form.getContractAddress(), form.getMethodName(), form.getMethodDesc(), form.getArgs());
        return ResultUtil.getRpcClientResult(mapResult);
    }

    @GET
    @Path(value="/codeHash/{contractAddress}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Obtaining contractscodeHash", order=419)
    @Parameters(value={@Parameter(parameterName="contractAddress", parameterDes="contractAddress")})
    @ResponseData(name="Return value", description="returnMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="result", description="ContractualcodeHash")}))
    public RpcClientResult codeHash(@PathParam(value="contractAddress") String contractAddress) {
        if (contractAddress == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "contractAddress data is empty"));
        }
        io.nuls.base.api.provider.Result<Map> mapResult = this.contractTools.codeHash(this.config.getChainId(), contractAddress);
        return ResultUtil.getRpcClientResult(mapResult);
    }

    @GET
    @Path(value="/tx/{hash}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Get transaction details of smart contracts", order=420)
    @Parameters(value={@Parameter(parameterName="hash", parameterDes="transactionhash")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=ContractTransactionDto.class))
    public RpcClientResult getContractTx(@PathParam(value="hash") String hash) {
        if (hash == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "hash is empty"));
        }
        io.nuls.base.api.provider.Result<Map> result = this.contractTools.getContractTx(this.config.getChainId(), hash);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        return clientResult;
    }

    @POST
    @Path(value="/computeAddress")
    @Produces(value={"application/json"})
    @ApiOperation(description="Calculate contract address", order=421)
    @Parameters(value={@Parameter(parameterName="Calculate contract address", parameterDes="Calculate contract address", requestType=@TypeDescriptor(value=ContractComputeAddress.class))})
    @ResponseData(name="Return value", description="returnMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="result", description="ContractualcodeHash")}))
    public RpcClientResult computeAddress(ContractComputeAddress form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form data is empty"));
        }
        io.nuls.base.api.provider.Result<Map> mapResult = this.contractTools.computeAddress(this.config.getChainId(), form.getSender(), form.getCodeHash(), form.getSalt());
        return ResultUtil.getRpcClientResult(mapResult);
    }

    @GET
    @Path(value="/contractCode/{contractAddress}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Obtaining contractscode", order=422)
    @Parameters(value={@Parameter(parameterName="contractAddress", parameterDes="contractAddress")})
    @ResponseData(name="Return value", description="returnMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="result", description="Contractualcode")}))
    public RpcClientResult contractCode(@PathParam(value="contractAddress") String contractAddress) {
        if (contractAddress == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "contractAddress data is empty"));
        }
        io.nuls.base.api.provider.Result<Map> mapResult = this.contractTools.contractCode(this.config.getChainId(), contractAddress);
        return ResultUtil.getRpcClientResult(mapResult);
    }

    @POST
    @Path(value="/create/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Transactions for publishing contracts", order=450)
    @Parameters(value={@Parameter(parameterName="Publish offline transactions for contracts", parameterDes="Publish offline transaction forms for contracts", requestType=@TypeDescriptor(value=ContractCreateOffline.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string"), @Key(name="contractAddress", description="Generated contract address")}))
    public RpcClientResult createTxOffline(ContractCreateOffline form) {
        Result result = NulsSDKTool.createContractTxOffline((String)form.getSender(), (BigInteger)form.getSenderBalance(), (String)form.getNonce(), (String)form.getAlias(), (String)form.getContractCode(), (long)form.getGasLimit(), (Object[])form.getArgs(), (String[])form.getArgsType(), (String)form.getRemark());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/call/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Transaction calling contract", order=451)
    @Parameters(value={@Parameter(parameterName="Call contract offline transaction", parameterDes="Call contract offline transaction form", requestType=@TypeDescriptor(value=ContractCallOffline.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult callTxOffline(ContractCallOffline form) {
        String[][] multyAssetValues = form.getMultyAssetValues();
        Result result = NulsSDKTool.callContractTxOffline((String)form.getSender(), (BigInteger)form.getSenderBalance(), (String)form.getNonce(), (BigInteger)form.getValue(), (String)form.getContractAddress(), (long)form.getGasLimit(), (String)form.getMethodName(), (String)form.getMethodDesc(), (Object[])form.getArgs(), (String[])form.getArgsType(), (String)form.getRemark(), Utils.multyAssetObjectArray(multyAssetValues));
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/delete/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Delete contract transactions", order=452)
    @Parameters(value={@Parameter(parameterName="Delete contract offline transaction", parameterDes="Delete offline transaction form for contract", requestType=@TypeDescriptor(value=ContractDeleteOffline.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult deleteTxOffline(ContractDeleteOffline form) {
        Result result = NulsSDKTool.deleteContractTxOffline((String)form.getSender(), (BigInteger)form.getSenderBalance(), (String)form.getNonce(), (String)form.getContractAddress(), (String)form.getRemark());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/tokentransfer/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - contracttokenTransfer transaction", order=453)
    @Parameters(value={@Parameter(parameterName="tokenOffline transfer transaction", parameterDes="tokenTransfer Offline Transaction Form", requestType=@TypeDescriptor(value=ContractTokenTransferOffline.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult tokenTransferOffline(ContractTokenTransferOffline form) {
        Result result = NulsSDKTool.tokenTransferTxOffline((String)form.getFromAddress(), (BigInteger)form.getSenderBalance(), (String)form.getNonce(), (String)form.getToAddress(), (String)form.getContractAddress(), (long)form.getGasLimit(), (BigInteger)form.getAmount(), (String)form.getRemark());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/transfer2contract/offline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly - Transfer from account address to contract address(Main chain assets)Contract transactions", order=454)
    @Parameters(value={@Parameter(parameterName="Transfer offline transaction to contract address", parameterDes="Transfer offline transaction form to contract address", requestType=@TypeDescriptor(value=ContractTransferOffline.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization string")}))
    public RpcClientResult transferToContractOffline(ContractTransferOffline form) {
        Result result = NulsSDKTool.transferToContractTxOffline((String)form.getFromAddress(), (BigInteger)form.getSenderBalance(), (String)form.getNonce(), (String)form.getToAddress(), (long)form.getGasLimit(), (BigInteger)form.getAmount(), (String)form.getRemark());
        return ResultUtil.getRpcClientResult(result);
    }
}

