/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.provider.model.ErrorData;
import java.util.HashMap;
import java.util.Map;

public class RpcClientResult {
    private boolean success;
    private Object data;
    @JsonIgnore
    private Map map;

    public RpcClientResult() {
    }

    public RpcClientResult(boolean success, ErrorData errorData) {
        this.success = success;
        this.data = errorData;
    }

    public RpcClientResult(boolean success, Object data) {
        this.success = success;
        this.data = data;
    }

    public static RpcClientResult getSuccess(Object data) {
        return new RpcClientResult(true, data);
    }

    public static RpcClientResult getFailed(ErrorData errorData) {
        return new RpcClientResult(false, errorData);
    }

    public static RpcClientResult getFailed(String msg) {
        return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.DATA_ERROR.getCode(), msg));
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @JsonIgnore
    public boolean isFailed() {
        return !this.success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean dataToBooleanValue() {
        return (Boolean)((Map)this.data).get("value");
    }

    public String dataToStringValue() {
        Object object = ((Map)this.data).get("value");
        if (null != object) {
            return (String)object;
        }
        return null;
    }

    public RpcClientResult resultMap() {
        this.map = new HashMap();
        return this;
    }

    public RpcClientResult map(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public RpcClientResult mapToData() {
        this.data = this.map;
        return this;
    }
}

