/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.model.dto.block;

import io.nuls.base.data.Block;
import io.nuls.base.data.Transaction;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.model.dto.TransactionDto;
import io.nuls.provider.model.dto.block.BlockHeaderDto;
import java.util.LinkedList;
import java.util.List;

@ApiModel(description="blockJSON Block information(Include block header information, Transaction information), Only return the corresponding partial data")
public class BlockDto {
    @ApiModelProperty(description="Block header information, Only return the corresponding partial data")
    private BlockHeaderDto header;
    @ApiModelProperty(description="Transaction List", type=@TypeDescriptor(value=List.class, collectionElement=TransactionDto.class))
    private List<TransactionDto> txs;

    public BlockDto() {
    }

    public BlockDto(Block block) throws NulsException {
        this.header = new BlockHeaderDto(block.getHeader());
        this.txs = new LinkedList<TransactionDto>();
        List txList = block.getTxs();
        if (txList == null || txList.isEmpty()) {
            return;
        }
        for (int i = 0; i < txList.size(); ++i) {
            this.txs.add(new TransactionDto((Transaction)txList.get(i), i));
        }
    }

    public BlockHeaderDto getHeader() {
        return this.header;
    }

    public void setHeader(BlockHeaderDto header) {
        this.header = header;
    }

    public List<TransactionDto> getTxs() {
        return this.txs;
    }

    public void setTxs(List<TransactionDto> txs) {
        this.txs = txs;
    }
}

