/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.rpctools;

import com.google.common.primitives.UnsignedBytes;
import io.nuls.base.data.Address;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.parse.SerializeUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.provider.model.dto.AccountBlockDTO;
import io.nuls.provider.rpctools.CallRpc;
import io.nuls.provider.rpctools.vo.Account;
import io.nuls.v2.error.AccountErrorCode;
import io.nuls.v2.util.AccountTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Hex;

@Component
public class AccountTools
implements CallRpc {
    public Account getAccountByAddress(int chainId, String address) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("chainId", chainId);
        param.put("address", address);
        return this.callRpc(ModuleE.AC.name, "ac_getAccountByAddress", param, res -> {
            if (res == null) {
                return null;
            }
            return (Account)MapUtils.mapToBean((Map)res, (Object)new Account());
        });
    }

    public boolean accountValid(int chainId, String address, String password) throws NulsException {
        return (Boolean)this.getAddressInfo(chainId, address, password, "valid");
    }

    public String getAddressPriKey(int chainId, String address, String password) throws NulsException {
        return (String)this.getAddressInfo(chainId, address, password, "priKey");
    }

    private <T> T getAddressInfo(int chainId, String address, String password, String key) throws NulsException {
        HashMap<String, Object> callParams = new HashMap<String, Object>(4);
        callParams.put("chainId", chainId);
        callParams.put("address", address);
        callParams.put("password", password);
        return (T)this.callRpc(ModuleE.AC.abbr, "ac_getPriKeyByAddress", callParams, res -> res.get(key));
    }

    public boolean isBlockAccount(int chainId, String address) {
        try {
            if (StringUtils.isBlank((String)address)) {
                return false;
            }
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chainId);
            params.put("address", address);
            boolean isBlock = this.callRpc(ModuleE.AC.abbr, "ac_isBlockAccount", params, res -> {
                if (res == null) {
                    return false;
                }
                return (boolean)((Boolean)res.get("value"));
            });
            return isBlock;
        }
        catch (Exception e) {
            Log.error((Throwable)e);
            return false;
        }
    }

    public AccountBlockDTO getBlockAccountInfo(int chainId, String address) {
        try {
            if (StringUtils.isBlank((String)address)) {
                return null;
            }
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chainId);
            params.put("address", address);
            AccountBlockDTO dto = this.callRpc(ModuleE.AC.abbr, "ac_getBlockAccountInfo", params, res -> {
                Object obj1;
                if (res == null) {
                    return null;
                }
                AccountBlockDTO result = new AccountBlockDTO();
                result.setAddress((String)res.get("address"));
                Object obj0 = res.get("types");
                if (obj0 != null) {
                    result.setTypes((List)obj0);
                }
                if ((obj1 = res.get("contracts")) != null) {
                    result.setContracts((List)obj1);
                }
                return result;
            });
            return dto;
        }
        catch (Exception e) {
            io.nuls.provider.utils.Log.error(e);
            return null;
        }
    }

    public Map getAllContractCallAccount(int chainId) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("chainId", chainId);
            Map result = this.callRpc(ModuleE.AC.abbr, "ac_getAllContractCallAccount", params, res -> {
                if (res == null) {
                    return null;
                }
                return res;
            });
            return result;
        }
        catch (Exception e) {
            io.nuls.provider.utils.Log.error(e);
            return null;
        }
    }

    public MultiSigAccount createMultiSigAccount(int chainId, List<String> pubKeys, int minSigns) throws NulsException {
        HashSet<String> pubkeySet = new HashSet<String>(pubKeys);
        if (pubkeySet.size() < pubKeys.size()) {
            throw new NulsException(AccountErrorCode.PUBKEY_REPEAT);
        }
        pubKeys = new ArrayList<String>(pubKeys);
        Collections.sort(pubKeys, new Comparator<String>(){
            private Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

            @Override
            public int compare(String k1, String k2) {
                return this.comparator.compare(Hex.decode((String)k1), Hex.decode((String)k2));
            }
        });
        Address address = new Address(chainId, BaseConstant.P2SH_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])AccountTool.createMultiSigAccountOriginBytes((int)chainId, (int)minSigns, pubKeys)));
        MultiSigAccount multiSigAccount = new MultiSigAccount();
        multiSigAccount.setChainId(chainId);
        multiSigAccount.setAddress(address);
        multiSigAccount.setM((byte)minSigns);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (String pubKey : pubKeys) {
            list.add(HexUtil.decode((String)pubKey));
        }
        multiSigAccount.setPubKeyList(list);
        return multiSigAccount;
    }
}

