/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.rpctools;

import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.constant.ErrorCode;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.netty.processor.ResponseMessageProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public interface CallRpc {
    default public <T, R> R callRpc(String module, String method, Map<String, Object> params, Function<T, R> callback) {
        Log.debug((String)"call {} rpc , method : {},param : {}", (Object[])new Object[]{module, method, params});
        Response cmdResp = null;
        try {
            cmdResp = ResponseMessageProcessor.requestAndResponse((String)module, (String)method, params);
            Log.debug((String)"result : {}", (Object[])new Object[]{cmdResp});
        }
        catch (Exception e) {
            Log.warn((String)"Calling remote interface failed. module:{} - interface:{} - message:{}", (Object[])new Object[]{module, method, e.getMessage()});
            throw new NulsRuntimeException(CommonCodeConstanst.FAILED, e.getMessage());
        }
        if (!cmdResp.isSuccess()) {
            String comment = cmdResp.getResponseComment();
            if (StringUtils.isBlank((String)comment)) {
                comment = "";
            }
            Log.warn((String)"Calling remote interface failed. module:{} - interface:{} - ResponseComment:{}", (Object[])new Object[]{module, method, comment});
            if (cmdResp.getResponseStatus() == 65536) {
                String errorCode = cmdResp.getResponseErrorCode();
                if (StringUtils.isBlank((String)errorCode)) {
                    throw new NulsRuntimeException(CommonCodeConstanst.SYS_UNKOWN_EXCEPTION, comment);
                }
                throw new NulsRuntimeException(ErrorCode.init((String)errorCode), comment);
            }
            if (StringUtils.isNotBlank((String)comment)) {
                throw new NulsRuntimeException(CommonCodeConstanst.FAILED, comment);
            }
            throw new NulsRuntimeException(CommonCodeConstanst.SYS_UNKOWN_EXCEPTION, "unknown error");
        }
        return callback.apply(((HashMap)cmdResp.getResponseData()).get(method));
    }
}

