/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.rpctools;

import io.nuls.base.api.provider.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.provider.api.cache.LedgerAssetCache;
import io.nuls.provider.api.model.AssetInfo;
import io.nuls.provider.model.dto.ContractTokenInfoDto;
import io.nuls.provider.rpctools.CallRpc;
import io.nuls.provider.rpctools.ContractTools;
import io.nuls.provider.rpctools.vo.AccountBalance;
import io.nuls.provider.rpctools.vo.AccountBalanceWithDecimals;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class LegderTools
implements CallRpc {
    @Autowired
    private ContractTools contractTools;
    @Autowired
    private LedgerAssetCache ledgerAssetCache;

    public Result<AccountBalance> getBalanceAndNonce(int chainId, int assetChainId, int assetId, String address) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("assetChainId", assetChainId);
        params.put("address", address);
        params.put("assetId", assetId);
        try {
            return this.callRpc(ModuleE.LG.abbr, "getBalanceNonce", params, map -> {
                if (map == null) {
                    return null;
                }
                AccountBalance balanceInfo = new AccountBalance();
                balanceInfo.setBalance(map.get("available").toString());
                balanceInfo.setTimeLock(map.get("timeHeightLocked").toString());
                balanceInfo.setConsensusLock(map.get("permanentLocked").toString());
                balanceInfo.setFreeze(map.get("freeze").toString());
                balanceInfo.setNonce((String)map.get("nonce"));
                balanceInfo.setTotalBalance(new BigInteger(balanceInfo.getBalance()).add(new BigInteger(balanceInfo.getConsensusLock())).add(new BigInteger(balanceInfo.getTimeLock())).toString());
                balanceInfo.setNonceType((Integer)map.get("nonceType"));
                return new Result((Object)balanceInfo);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<AccountBalanceWithDecimals> getBalanceAndNonceWithDecimals(int chainId, int assetChainId, int assetId, String address) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("chainId", chainId);
        params.put("assetChainId", assetChainId);
        params.put("address", address);
        params.put("assetId", assetId);
        try {
            return this.callRpc(ModuleE.LG.abbr, "getBalanceNonce", params, map -> {
                if (map == null) {
                    return null;
                }
                AccountBalanceWithDecimals balanceInfo = new AccountBalanceWithDecimals();
                balanceInfo.setBalance(map.get("available").toString());
                balanceInfo.setTimeLock(map.get("timeHeightLocked").toString());
                balanceInfo.setConsensusLock(map.get("permanentLocked").toString());
                balanceInfo.setFreeze(map.get("freeze").toString());
                balanceInfo.setNonce((String)map.get("nonce"));
                balanceInfo.setTotalBalance(new BigInteger(balanceInfo.getBalance()).add(new BigInteger(balanceInfo.getConsensusLock())).add(new BigInteger(balanceInfo.getTimeLock())).toString());
                balanceInfo.setNonceType((Integer)map.get("nonceType"));
                AssetInfo assetInfo = this.ledgerAssetCache.getAssetInfo(assetChainId, assetId);
                if (assetInfo != null) {
                    balanceInfo.setDecimals(assetInfo.getDecimals());
                }
                return new Result((Object)balanceInfo);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> getAllAsset(int chainId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("chainId", chainId);
        try {
            return this.callRpc(ModuleE.LG.abbr, "lg_get_all_asset", params, map -> {
                if (map == null) {
                    return null;
                }
                List assets = (List)map.get("assets");
                return new Result(assets);
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<AssetInfo> getAsset(int assetChainId, int assetId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("chainId", assetChainId);
        params.put("assetId", assetId);
        try {
            return this.callRpc(ModuleE.LG.abbr, "getAssetRegInfoByAssetId", params, map -> {
                if (map == null || map.get("assetSymbol") == null) {
                    return Result.fail((String)CommonCodeConstanst.DATA_NOT_FOUND.getCode(), null);
                }
                int decimalPlace = Integer.parseInt(map.get("decimalPlace").toString());
                String symbol = map.get("assetSymbol").toString();
                return new Result((Object)new AssetInfo(assetChainId, assetId, symbol, decimalPlace));
            });
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<List<AccountBalanceWithDecimals>> getBalanceWithDecimalsList(int chainId, List<Map> coinDtoList, String address) {
        try {
            ArrayList<AccountBalanceWithDecimals> accountBalanceList = new ArrayList<AccountBalanceWithDecimals>();
            for (int i = 0; i < coinDtoList.size(); ++i) {
                Map map = coinDtoList.get(i);
                int assetChainId = (Integer)map.get("chainId");
                int assetId = (Integer)map.get("assetId");
                String contractAddress = (String)map.get("contractAddress");
                if (StringUtils.isBlank((String)contractAddress)) {
                    AccountBalanceWithDecimals accountBalance = (AccountBalanceWithDecimals)this.getBalanceAndNonceWithDecimals(chainId, assetChainId, assetId, address).getData();
                    accountBalance.setAssetChainId(assetChainId);
                    accountBalance.setAssetId(assetId);
                    accountBalance.setContractAddress(contractAddress);
                    accountBalanceList.add(accountBalance);
                    continue;
                }
                ContractTokenInfoDto dto = (ContractTokenInfoDto)this.contractTools.getTokenBalance(chainId, contractAddress, address).getData();
                AccountBalanceWithDecimals accountBalance = new AccountBalanceWithDecimals();
                accountBalance.setAssetChainId(assetChainId);
                accountBalance.setAssetId(assetId);
                accountBalance.setContractAddress(contractAddress);
                accountBalance.setDecimals((int)dto.getDecimals());
                if (dto == null) {
                    accountBalance.setBalance("0");
                    accountBalance.setTotalBalance("0");
                    accountBalance.setConsensusLock("0");
                } else {
                    accountBalance.setBalance(dto.getAmount());
                    accountBalance.setConsensusLock(dto.getLockAmount());
                    BigInteger balance = new BigInteger(dto.getAmount());
                    BigInteger lockBalance = new BigInteger(dto.getLockAmount());
                    accountBalance.setTotalBalance(balance.add(lockBalance).toString());
                }
                accountBalance.setTimeLock("0");
                accountBalance.setFreeze("0");
                accountBalanceList.add(accountBalance);
            }
            return new Result(accountBalanceList);
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<List<AccountBalance>> getBalanceList(int chainId, List<Map> coinDtoList, String address) {
        try {
            ArrayList<AccountBalance> accountBalanceList = new ArrayList<AccountBalance>();
            for (int i = 0; i < coinDtoList.size(); ++i) {
                Map map = coinDtoList.get(i);
                int assetChainId = (Integer)map.get("chainId");
                int assetId = (Integer)map.get("assetId");
                String contractAddress = (String)map.get("contractAddress");
                if (StringUtils.isBlank((String)contractAddress)) {
                    AccountBalance accountBalance = (AccountBalance)this.getBalanceAndNonce(chainId, assetChainId, assetId, address).getData();
                    accountBalance.setAssetChainId(assetChainId);
                    accountBalance.setAssetId(assetId);
                    accountBalance.setContractAddress(contractAddress);
                    accountBalanceList.add(accountBalance);
                    continue;
                }
                ContractTokenInfoDto dto = (ContractTokenInfoDto)this.contractTools.getTokenBalance(chainId, contractAddress, address).getData();
                AccountBalance accountBalance = new AccountBalance();
                accountBalance.setAssetChainId(assetChainId);
                accountBalance.setAssetId(assetId);
                accountBalance.setContractAddress(contractAddress);
                if (dto == null) {
                    accountBalance.setBalance("0");
                    accountBalance.setTotalBalance("0");
                    accountBalance.setConsensusLock("0");
                } else {
                    accountBalance.setBalance(dto.getAmount());
                    accountBalance.setConsensusLock(dto.getLockAmount());
                    BigInteger balance = new BigInteger(dto.getAmount());
                    BigInteger lockBalance = new BigInteger(dto.getLockAmount());
                    accountBalance.setTotalBalance(balance.add(lockBalance).toString());
                }
                accountBalance.setTimeLock("0");
                accountBalance.setFreeze("0");
                accountBalanceList.add(accountBalance);
            }
            return new Result(accountBalanceList);
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }
}

