/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.nuls.base.api.provider.Provider;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.core.core.annotation.RpcMethod;
import io.nuls.core.core.config.ConfigurationLoader;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.io.IoUtils;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.annotation.ApiType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import net.steppschuh.markdowngenerator.table.Table;
import net.steppschuh.markdowngenerator.text.Text;
import net.steppschuh.markdowngenerator.text.heading.Heading;
import org.apache.commons.beanutils.BeanUtils;

public class ApiDocTool {
    static String appName = "nuls-api";
    static Set<String> exclusion = Set.of("io.nuls.base.protocol.cmd", "io.nuls.core.rpc.cmd.kernel", "io.nuls.core.rpc.modulebootstrap");
    static Set<Class> baseType = new HashSet<Class>();

    public static void main(String[] args) throws IOException {
        ConfigurationLoader configurationLoader = new ConfigurationLoader();
        configurationLoader.load();
        Provider.ProviderType providerType = Provider.ProviderType.valueOf((String)configurationLoader.getValue("providerType"));
        int defaultChainId = Integer.parseInt(configurationLoader.getValue("chainId"));
        ServiceManager.init((Integer)defaultChainId, (Provider.ProviderType)providerType);
        SpringLiteContext.init((String[])new String[]{"io.nuls"});
        Gen.genDoc();
        Gen.genPostmanJSON();
        System.exit(0);
    }

    static {
        baseType.add(Integer.class);
        baseType.add(Integer.TYPE);
        baseType.add(Long.class);
        baseType.add(Long.TYPE);
        baseType.add(Float.class);
        baseType.add(Float.TYPE);
        baseType.add(Double.class);
        baseType.add(Double.TYPE);
        baseType.add(Character.class);
        baseType.add(Character.TYPE);
        baseType.add(Short.class);
        baseType.add(Short.TYPE);
        baseType.add(Boolean.class);
        baseType.add(Boolean.TYPE);
        baseType.add(Byte.class);
        baseType.add(Byte.TYPE);
        baseType.add(String.class);
        baseType.add(Object[].class);
        baseType.add(String[].class);
        baseType.add(String[][].class);
        baseType.add(BigInteger.class);
        baseType.add(BigDecimal.class);
    }

    public static class Gen {
        private static final String NA = "N/A";

        public static List<CmdDes>[] buildData() {
            Collection beanList = SpringLiteContext.getAllBeanList();
            List[] resultArray = new List[2];
            ArrayList restfulCmdDesList = new ArrayList();
            ArrayList jsonrpcCmdDesList = new ArrayList();
            resultArray[0] = restfulCmdDesList;
            resultArray[1] = jsonrpcCmdDesList;
            beanList.forEach(cmd -> {
                Method[] methods;
                Class<?> clazs = cmd.getClass();
                Api api = clazs.getAnnotation(Api.class);
                if (api == null) {
                    return;
                }
                if (exclusion.contains(clazs.getPackageName())) {
                    Log.info((String)"skip{}Generate document in package{}Within the exclusion range", (Object[])new Object[]{clazs.getSimpleName(), clazs.getPackageName()});
                    return;
                }
                ApiType apiType = api.type();
                String cmdBaseName = "";
                String methodPath = "";
                boolean restful = apiType.equals((Object)ApiType.RESTFUL);
                boolean jsonrpc = apiType.equals((Object)ApiType.JSONRPC);
                if (restful) {
                    Path annotation = clazs.getAnnotation(Path.class);
                    cmdBaseName = annotation.value();
                }
                for (Method method : methods = clazs.getMethods()) {
                    ApiOperation annotation = method.getAnnotation(ApiOperation.class);
                    if (annotation == null) continue;
                    ApiOperation cmdAnnotation = annotation;
                    CmdDes cmdDes = new CmdDes();
                    String detailDesc = cmdAnnotation.detailDesc();
                    if (StringUtils.isBlank((String)detailDesc)) {
                        detailDesc = cmdAnnotation.description();
                    }
                    cmdDes.detailDesc = detailDesc;
                    cmdDes.order = cmdAnnotation.order();
                    cmdDes.cmdType = apiType.name();
                    if (restful) {
                        Path methodPathAnnotation = method.getAnnotation(Path.class);
                        if (methodPathAnnotation != null) {
                            methodPath = methodPathAnnotation.value();
                        }
                        if (StringUtils.isBlank((String)methodPath)) {
                            methodPath = "";
                        }
                        String httpMethod = "";
                        POST post = method.getAnnotation(POST.class);
                        if (post != null) {
                            httpMethod = post.annotationType().getSimpleName();
                        } else {
                            GET get = method.getAnnotation(GET.class);
                            if (get != null) {
                                httpMethod = get.annotationType().getSimpleName();
                            } else {
                                PUT put = method.getAnnotation(PUT.class);
                                if (put != null) {
                                    httpMethod = put.annotationType().getSimpleName();
                                } else {
                                    DELETE delete = method.getAnnotation(DELETE.class);
                                    if (delete != null) {
                                        httpMethod = delete.annotationType().getSimpleName();
                                    }
                                }
                            }
                        }
                        cmdDes.httpMethod = httpMethod;
                    } else if (jsonrpc) {
                        RpcMethod rpcMethod = method.getAnnotation(RpcMethod.class);
                        cmdDes.httpMethod = "POST";
                        methodPath = rpcMethod.value();
                    }
                    cmdDes.cmdName = cmdBaseName + methodPath;
                    cmdDes.des = cmdAnnotation.description();
                    cmdDes.parameters = Gen.buildParam(apiType, method);
                    annotation = method.getAnnotation(ResponseData.class);
                    if (annotation != null) {
                        ResponseData responseData = (ResponseData)annotation;
                        cmdDes.result = Gen.buildResultDes(responseData.responseType(), responseData.description(), responseData.name(), true);
                    }
                    if (restful) {
                        restfulCmdDesList.add(cmdDes);
                        continue;
                    }
                    if (!jsonrpc) continue;
                    jsonrpcCmdDesList.add(cmdDes);
                }
            });
            return resultArray;
        }

        public static void genDoc() throws IOException {
            List<CmdDes>[] cmdDesList = Gen.buildData();
            List<CmdDes> restfulCmdDesList = cmdDesList[0];
            List<CmdDes> jsonrpcCmdDesList = cmdDesList[1];
            restfulCmdDesList.sort((a, b) -> a.compareTo(b.order));
            jsonrpcCmdDesList.sort((a, b) -> a.compareTo(b.order));
            System.out.println("generateRESTFULDocument successful\uff1a" + Gen.createMarketDownDoc(restfulCmdDesList, ApiType.RESTFUL, "./readme.md"));
            System.out.println("generateJSONRPCDocument successful\uff1a" + Gen.createMarketDownDoc(jsonrpcCmdDesList, ApiType.JSONRPC, "./readme.md"));
        }

        public static void genJSON() throws IOException {
            Object[] cmdDesList = Gen.buildData();
            Log.info((String)"{}", (Object[])cmdDesList);
            Object restfulCmdDesList = cmdDesList[0];
            Object jsonrpcCmdDesList = cmdDesList[1];
            restfulCmdDesList.sort((a, b) -> a.compareTo(b.order));
            jsonrpcCmdDesList.sort((a, b) -> a.compareTo(b.order));
            System.out.println("generateRESTFULDocument successful\uff1a" + Gen.createJSONConfig((List<CmdDes>)restfulCmdDesList, ApiType.RESTFUL, "./readme.md"));
            System.out.println("generateJSONRPCDocument successful\uff1a" + Gen.createJSONConfig((List<CmdDes>)jsonrpcCmdDesList, ApiType.JSONRPC, "./readme.md"));
        }

        public static void genPostmanJSON() throws IOException {
            List<CmdDes>[] cmdDesList = Gen.buildData();
            List<CmdDes> restfulCmdDesList = cmdDesList[0];
            List<CmdDes> jsonrpcCmdDesList = cmdDesList[1];
            restfulCmdDesList.sort((a, b) -> a.compareTo(b.order));
            jsonrpcCmdDesList.sort((a, b) -> a.compareTo(b.order));
            System.out.println("generatePostman-RESTFULImport file successful\uff1a" + Gen.createPostmanJSONConfig(restfulCmdDesList, ApiType.RESTFUL, "./readme.md"));
            System.out.println("generatePostman-JSONRPCImport file successful\uff1a" + Gen.createPostmanJSONConfig(jsonrpcCmdDesList, ApiType.JSONRPC, "./readme.md"));
        }

        public static List<ResultDes> buildParam(ApiType apiType, Method method) {
            List<Parameter> parameters;
            Parameters annotation = method.getAnnotation(Parameters.class);
            if (annotation != null) {
                parameters = Arrays.asList(annotation.value());
            } else {
                Parameter[] parameterAry = (Parameter[])method.getAnnotationsByType(Parameter.class);
                parameters = Arrays.asList(parameterAry);
            }
            ArrayList<ResultDes> param = new ArrayList<ResultDes>();
            parameters.stream().forEach(parameter -> {
                ResultDes res = new ResultDes();
                res.type = parameter.parameterType();
                res.name = parameter.parameterName();
                res.des = parameter.parameterDes();
                res.canNull = parameter.canNull();
                Class requestType = parameter.requestType().value();
                if (baseType.contains(requestType)) {
                    param.addAll(Gen.buildResultDes(parameter.requestType(), res.des, res.name, res.canNull));
                } else {
                    if (ApiType.RESTFUL.equals((Object)apiType)) {
                        try {
                            res.formJsonOfRestful = JSONUtils.obj2PrettyJson((Object)Gen.newInstance(requestType));
                        }
                        catch (Exception e) {
                            System.out.println(String.format("Form named [%s] has no non-args-constructor or other error [%s].", requestType.getSimpleName(), e.getMessage()));
                        }
                    }
                    res.list = Gen.buildResultDes(parameter.requestType(), res.des, res.name, res.canNull);
                    res.type = parameter.requestType().value().getSimpleName().toLowerCase();
                    if (parameter.requestType().value() == List.class && baseType.contains(parameter.requestType().collectionElement())) {
                        res.type = res.list.get((int)0).type;
                        res.list = null;
                    }
                    param.add(res);
                }
            });
            return param;
        }

        private static Object newInstance(Class cls) throws IllegalAccessException, InstantiationException, InvocationTargetException {
            Field[] fields;
            Object o = cls.newInstance();
            for (Field field : fields = cls.getDeclaredFields()) {
                Object o1;
                if (baseType.contains(field.getType())) continue;
                if (field.getType() == List.class) {
                    Class element;
                    o1 = new ArrayList();
                    List o2 = (List)o1;
                    ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
                    if (apiModelProperty != null && !baseType.contains(element = apiModelProperty.type().collectionElement())) {
                        o2.add(Gen.newInstance(element));
                    }
                } else {
                    o1 = field.getType() == Map.class ? new HashMap() : (field.getType() == Set.class ? new HashSet() : (field.getType().isArray() ? Array.newInstance(field.getType().getComponentType(), 0) : field.getType().newInstance()));
                }
                BeanUtils.setProperty(o, (String)field.getName(), o1);
            }
            return o;
        }

        public static List<ResultDes> buildResultDes(TypeDescriptor typeDescriptor, String des, String name, boolean canNull) {
            ResultDes resultDes = new ResultDes();
            if (typeDescriptor.value() == Void.class) {
                resultDes.type = "void";
                resultDes.des = des;
                resultDes.name = NA;
                return List.of(resultDes);
            }
            if (baseType.contains(typeDescriptor.value())) {
                resultDes.des = des;
                resultDes.name = name;
                resultDes.type = typeDescriptor.value().getSimpleName().toLowerCase();
                resultDes.canNull = canNull;
                return List.of(resultDes);
            }
            if (typeDescriptor.value() == Map.class) {
                return Gen.mapToResultDes(typeDescriptor);
            }
            if (List.class == typeDescriptor.value()) {
                if (baseType.contains(typeDescriptor.collectionElement())) {
                    resultDes.type = "list&lt;" + typeDescriptor.collectionElement().getSimpleName() + ">";
                    resultDes.des = des;
                    resultDes.name = name;
                    resultDes.canNull = canNull;
                    return List.of(resultDes);
                }
                if (typeDescriptor.collectionElement() == Map.class) {
                    return Gen.mapToResultDes(typeDescriptor);
                }
                return Gen.classToResultDes(typeDescriptor.collectionElement());
            }
            if (Object[].class == typeDescriptor.value()) {
                resultDes.des = des;
                resultDes.name = name;
                resultDes.type = "object[]";
                resultDes.canNull = canNull;
                return List.of(resultDes);
            }
            ApiModel annotation = typeDescriptor.value().getAnnotation(ApiModel.class);
            if (annotation == null) {
                resultDes.type = typeDescriptor.value().getSimpleName().toLowerCase();
                resultDes.name = name;
                resultDes.des = des;
                resultDes.canNull = canNull;
                return List.of(resultDes);
            }
            return Gen.classToResultDes(typeDescriptor.value());
        }

        public static List<ResultDes> mapToResultDes(TypeDescriptor typeDescriptor) {
            Key[] keys = typeDescriptor.mapKeys();
            ArrayList<ResultDes> res = new ArrayList<ResultDes>();
            Arrays.stream(keys).forEach(key -> {
                ResultDes rd = new ResultDes();
                if (baseType.contains(key.valueType())) {
                    rd.type = key.valueType().getSimpleName().toLowerCase();
                    rd.name = key.name();
                    rd.des = key.description();
                } else if (List.class == key.valueType()) {
                    rd.name = key.name();
                    rd.des = key.description();
                    if (baseType.contains(key.valueElement()) || key.valueElement() == Map.class) {
                        rd.type = "list&lt;" + key.valueElement().getSimpleName() + ">";
                    } else {
                        rd.list = Gen.classToResultDes(key.valueElement());
                        rd.type = "list&lt;object>";
                    }
                } else if (Map.class == key.valueType()) {
                    rd.type = "map";
                    rd.name = key.name();
                    rd.des = key.description();
                } else {
                    ApiModel annotation = key.valueType().getAnnotation(ApiModel.class);
                    if (annotation == null) {
                        rd.type = key.valueType().getSimpleName().toLowerCase();
                        rd.name = key.name();
                        rd.des = key.description();
                    } else {
                        rd.type = "object";
                        rd.name = key.name();
                        rd.des = key.description();
                        rd.list = Gen.classToResultDes(key.valueType());
                    }
                }
                res.add(rd);
            });
            return res;
        }

        public static List<ResultDes> classToResultDes(Class<?> clzs) {
            if (clzs == Void.class) {
                return null;
            }
            ApiModel annotation = clzs.getAnnotation(ApiModel.class);
            if (annotation == null) {
                System.err.println(clzs.getName());
                throw new IllegalArgumentException("Must be declared when the return value is a complex objectApiModuleannotation + " + clzs.getSimpleName());
            }
            LinkedList<Field> list = new LinkedList<Field>();
            list.addAll(Arrays.asList(clzs.getDeclaredFields()));
            Class<?> clzsTemp = clzs.getSuperclass();
            while (clzsTemp.getAnnotation(ApiModel.class) != null) {
                list.addAll(0, Arrays.asList(clzsTemp.getDeclaredFields()));
                clzsTemp = clzsTemp.getSuperclass();
            }
            Field[] fileds = new Field[list.size()];
            list.toArray(fileds);
            ArrayList<ResultDes> filedList = new ArrayList<ResultDes>();
            Arrays.stream(fileds).forEach(filed -> {
                ApiModelProperty ann = filed.getAnnotation(ApiModelProperty.class);
                ApiModelProperty apiModelProperty = ann;
                if (apiModelProperty == null) {
                    Log.warn((String)"Discovered unconfiguredApiModelPropertyAnnotatedfiled:{}", (Object[])new Object[]{clzs.getSimpleName() + "#" + filed.getName()});
                    return;
                }
                ResultDes filedDes = new ResultDes();
                filedDes.des = apiModelProperty.description();
                filedDes.name = filed.getName();
                boolean bl = filedDes.canNull = !apiModelProperty.required();
                if (apiModelProperty.type().value() != Void.class) {
                    if (baseType.contains(apiModelProperty.type().collectionElement())) {
                        filedDes.type = "list&lt;" + apiModelProperty.type().collectionElement().getSimpleName() + ">";
                    } else {
                        filedDes.list = Gen.buildResultDes(apiModelProperty.type(), filedDes.des, filedDes.name, filedDes.canNull);
                        if (apiModelProperty.type().value() == List.class) {
                            filedDes.type = "list&lt;object>";
                        } else if (apiModelProperty.type().value() == Map.class) {
                            filedDes.type = "map";
                        }
                    }
                } else if (baseType.contains(filed.getType())) {
                    filedDes.type = filed.getType().getSimpleName().toLowerCase();
                } else {
                    ApiModel filedAnn = filed.getType().getAnnotation(ApiModel.class);
                    if (filedAnn == null) {
                        Log.warn((String)"findApiModelPropertyAnnotatedfiledThe type is a complex object, but the object is not annotatedApiModel,filed:{}", (Object[])new Object[]{clzs.getName() + "#" + filed.getName()});
                        filedDes.type = filed.getType().getSimpleName().toLowerCase();
                    } else if (clzs == filed.getType()) {
                        Log.warn((String)"Discovering circular references\uff1a{}", (Object[])new Object[]{clzs});
                        filedDes.type = "object&lt;" + clzs.getSimpleName().toLowerCase() + ">";
                    } else {
                        filedDes.list = Gen.classToResultDes(filed.getType());
                        filedDes.type = "object";
                    }
                }
                filedList.add(filedDes);
            });
            return filedList;
        }

        public static String createJSONConfig(List<CmdDes> cmdDesList, ApiType apiType, String tempFile) throws IOException {
            URL resource = ApiDocTool.class.getClassLoader().getResource(".");
            File temp = new File(resource.getFile());
            String parent = temp.getParentFile().getParent();
            File file = new File(parent + File.separator + tempFile);
            if (!file.exists()) {
                throw new RuntimeException("The template file does not exist");
            }
            File mdFile = new File(file.getParentFile().getAbsolutePath() + File.separator + "documents" + File.separator + appName + "_" + apiType.name() + ".json");
            if (mdFile.exists()) {
                mdFile.delete();
            }
            mdFile.createNewFile();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(mdFile));){
                cmdDesList.forEach(cmd -> {
                    try {
                        StringWriter stringWriter = new StringWriter();
                        try (BufferedWriter sbw = new BufferedWriter(stringWriter);){
                            Gen.writeMarkdown(cmd, sbw, null, null);
                            sbw.flush();
                            cmd.md = stringWriter.toString();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                writer.write(JSONUtils.obj2json(cmdDesList));
            }
            return mdFile.getAbsolutePath();
        }

        public static String createPostmanJSONConfig(List<CmdDes> cmdDesList, ApiType apiType, String tempFile) throws IOException {
            URL resource = ApiDocTool.class.getClassLoader().getResource(".");
            File temp = new File(resource.getFile());
            String parent = temp.getParentFile().getParent();
            File file = new File(parent + File.separator + tempFile);
            if (!file.exists()) {
                throw new RuntimeException("The template file does not exist");
            }
            File mdFile = new File(file.getParentFile().getAbsolutePath() + File.separator + "documents" + File.separator + appName + "_Postman_" + apiType.name() + ".json");
            if (mdFile.exists()) {
                mdFile.delete();
            }
            mdFile.createNewFile();
            cmdDesList.forEach(cmd -> {
                try {
                    StringWriter stringWriter = new StringWriter();
                    try (BufferedWriter sbw = new BufferedWriter(stringWriter);){
                        Gen.writePostmanDescMarkdown(cmd, sbw);
                        sbw.flush();
                        cmd.md = stringWriter.toString();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(mdFile));){
                String postmanFormatJson = Gen.genPostmanFormatJson(cmdDesList, apiType);
                writer.write(postmanFormatJson);
            }
            return mdFile.getAbsolutePath();
        }

        public static String createMarketDownDoc(List<CmdDes> cmdDesList, ApiType apiType, String tempFile) throws IOException {
            File egJsonrpcFile;
            URL resource = ApiDocTool.class.getClassLoader().getResource(".");
            File temp = new File(resource.getFile());
            String parent = temp.getParentFile().getParent();
            File file = new File(parent + File.separator + tempFile);
            if (!file.exists()) {
                throw new RuntimeException("The template file does not exist");
            }
            Map egMap = null;
            if (ApiType.JSONRPC.equals((Object)apiType)) {
                egJsonrpcFile = new File(file.getParentFile().getAbsolutePath() + File.separator + "documents" + File.separator + "eg_jsonrpc.json");
                String jsonrpcStr = IoUtils.readCharsToString((File)egJsonrpcFile, (String)StandardCharsets.UTF_8.name());
                egMap = JSONUtils.json2map((String)jsonrpcStr);
            } else if (ApiType.RESTFUL.equals((Object)apiType)) {
                egJsonrpcFile = new File(file.getParentFile().getAbsolutePath() + File.separator + "documents" + File.separator + "eg_restful.json");
                String restfulStr = IoUtils.readCharsToString((File)egJsonrpcFile, (String)StandardCharsets.UTF_8.name());
                egMap = JSONUtils.json2map((String)restfulStr);
            }
            File mdFile = new File(file.getParentFile().getAbsolutePath() + File.separator + "documents" + File.separator + appName + "_" + apiType.name() + ".md");
            if (mdFile.exists()) {
                mdFile.delete();
            }
            mdFile.createNewFile();
            try (FileOutputStream outputStream = new FileOutputStream(mdFile);
                 FileInputStream inputStream = new FileInputStream(file);){
                ((InputStream)inputStream).transferTo(outputStream);
                outputStream.flush();
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(mdFile, true));){
                writer.newLine();
                writer.write(new Heading((Object)"Interface List", 2).toString());
                writer.newLine();
                AtomicInteger i = new AtomicInteger(0);
                for (CmdDes cmd : cmdDesList) {
                    Gen.writeMarkdown(cmd, writer, i, egMap);
                }
            }
            return mdFile.getAbsolutePath();
        }

        private static void writeMarkdown(CmdDes cmd, BufferedWriter writer, AtomicInteger i, Map<String, Object> egMap) {
            try {
                Map egCmdMap;
                Object order = "";
                if (i != null) {
                    if (i.get() == 0) {
                        i.set(cmd.order);
                    } else {
                        String firstLetterOfOrder;
                        String currentFirstLetterOfOrder = String.valueOf(i.get()).substring(0, 1);
                        if (!currentFirstLetterOfOrder.equals(firstLetterOfOrder = String.valueOf(cmd.order).substring(0, 1))) {
                            i.set(cmd.order);
                        }
                    }
                    order = String.valueOf(i.getAndIncrement());
                    if (cmd.order < 100) {
                        order = "0".repeat(3 - ((String)order).length()) + (String)order;
                    }
                    order = ((String)order).substring(0, 1) + "." + Integer.parseInt(((String)order).substring(1)) + " ";
                }
                boolean jsonrpc = ApiType.JSONRPC.name().equals(cmd.cmdType);
                writer.write(new Heading((Object)((String)order + cmd.des), 3).toString());
                writer.newLine();
                writer.write(new Heading((Object)("Cmd: " + cmd.cmdName.replaceAll("_", "\\\\_")), 4).toString());
                writer.newLine();
                writer.write(new Text((Object)("_**Detailed description: " + cmd.detailDesc + "**_")).toString());
                writer.newLine();
                if (!jsonrpc) {
                    writer.write(new Heading((Object)("HttpMethod: " + cmd.httpMethod), 4).toString());
                    writer.newLine();
                }
                Gen.buildParam(writer, cmd.parameters, jsonrpc);
                Gen.buildResult(writer, cmd.result);
                String egReqDesc = "nothing";
                String egReqPathDesc = "slightly";
                String egRespDesc = "slightly";
                if (egMap != null && (egCmdMap = (Map)egMap.get(cmd.cmdName)) != null) {
                    Object request = egCmdMap.get("request");
                    Object requestPath = egCmdMap.get("requestPath");
                    Object response = egCmdMap.get("response");
                    if (request != null) {
                        egReqDesc = JSONUtils.obj2PrettyJson(request);
                        if (request instanceof Map && ((Map)request).size() == 0) {
                            egReqDesc = "nothing";
                        }
                    }
                    if (requestPath != null && StringUtils.isNotBlank((String)requestPath.toString())) {
                        egReqPathDesc = requestPath.toString();
                        if (request != null && request instanceof Map && ((Map)request).size() == 0) {
                            egReqDesc = "nothing";
                        }
                    }
                    if (response != null) {
                        egRespDesc = JSONUtils.obj2PrettyJson(response);
                    }
                }
                writer.newLine();
                writer.write(new Heading((Object)"Example request data: ", 4).toString());
                writer.newLine();
                if (jsonrpc) {
                    if ("nothing".equals(egReqDesc)) {
                        writer.write(new Text((Object)egReqDesc).toString());
                    } else {
                        writer.newLine();
                        writer.write(new Text((Object)"```json").toString());
                        writer.newLine();
                        writer.write(new Text((Object)egReqDesc).toString());
                        writer.newLine();
                        writer.write(new Text((Object)"```").toString());
                    }
                    writer.newLine();
                } else {
                    writer.newLine();
                    writer.write(new Text((Object)"_**request path:**_").toString());
                    writer.newLine();
                    writer.write(new Text((Object)egReqPathDesc).toString());
                    writer.newLine();
                    writer.newLine();
                    writer.write(new Text((Object)"_**request form data:**_").toString());
                    writer.newLine();
                    if ("nothing".equals(egReqDesc)) {
                        writer.write(new Text((Object)egReqDesc).toString());
                    } else {
                        writer.newLine();
                        writer.write(new Text((Object)"```json").toString());
                        writer.newLine();
                        writer.write(new Text((Object)egReqDesc).toString());
                        writer.newLine();
                        writer.write(new Text((Object)"```").toString());
                    }
                    writer.newLine();
                }
                writer.newLine();
                writer.write(new Heading((Object)"Example response data: ", 4).toString());
                writer.newLine();
                if ("slightly".equals(egRespDesc)) {
                    writer.write(new Text((Object)egRespDesc).toString());
                } else {
                    writer.newLine();
                    writer.write(new Text((Object)"```json").toString());
                    writer.newLine();
                    writer.write(new Text((Object)egRespDesc).toString());
                    writer.newLine();
                    writer.write(new Text((Object)"```").toString());
                }
                writer.newLine();
                writer.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private static void writePostmanDescMarkdown(CmdDes cmd, BufferedWriter writer) {
            try {
                writer.newLine();
                Gen.buildParam(writer, cmd.parameters, true);
                Gen.buildResult(writer, cmd.result);
                writer.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private static void buildResult(BufferedWriter writer, List<ResultDes> result) throws IOException {
            writer.newLine();
            writer.newLine();
            writer.write(new Heading((Object)"Return value", 4).toString());
            if (result == null) {
                writer.newLine();
                writer.write("No return value");
                return;
            }
            Table.Builder tableBuilder = new Table.Builder().withAlignments(new Integer[]{2, 1, 2}).addRow(new Object[]{"Field Name", "Field type", "Parameter Description"});
            Gen.buildResult(tableBuilder, result, 0);
            writer.newLine();
            writer.write(tableBuilder.build().toString());
        }

        private static void buildResult(Table.Builder tableBuilder, List<ResultDes> result, int depth) {
            result.forEach(r -> {
                tableBuilder.addRow(new Object[]{"&nbsp;".repeat(depth * 8) + r.name, r.type.toLowerCase(), r.des});
                if (r.list != null) {
                    Gen.buildResult(tableBuilder, r.list, depth + 1);
                }
            });
        }

        private static void buildParam(BufferedWriter writer, List<ResultDes> parameters, boolean jsonrpc) throws IOException {
            if (!jsonrpc) {
                parameters.forEach(des -> {
                    if (des.formJsonOfRestful != null) {
                        try {
                            writer.newLine();
                            writer.write(new Heading((Object)"Form json data: ", 4).toString());
                            writer.newLine();
                            writer.newLine();
                            writer.write(new Text((Object)"```json").toString());
                            writer.newLine();
                            writer.write(new Text((Object)des.formJsonOfRestful).toString());
                            writer.newLine();
                            writer.write(new Text((Object)"```").toString());
                            writer.newLine();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            writer.newLine();
            writer.write(new Heading((Object)"parameter list", 4).toString());
            if (parameters == null || parameters.isEmpty()) {
                writer.newLine();
                writer.write("No parameters");
                return;
            }
            Table.Builder tableBuilder = new Table.Builder().withAlignments(new Integer[]{2, 1, 2, 1}).addRow(new Object[]{"Parameter Name", "Parameter type", "Parameter Description", "Is it mandatory to fill in"});
            Gen.buildParam(tableBuilder, parameters, 0, jsonrpc);
            writer.newLine();
            writer.write(tableBuilder.build().toString());
        }

        private static void buildParam(Table.Builder tableBuilder, List<ResultDes> result, int depth, boolean jsonrpc) {
            result.forEach(r -> {
                tableBuilder.addRow(new Object[]{"&nbsp;".repeat(depth * 8) + r.name, r.type.toLowerCase(), r.des, !r.canNull ? "yes" : "no"});
                if (r.list != null) {
                    Gen.buildParam(tableBuilder, r.list, depth + 1, jsonrpc);
                }
            });
        }

        public static String genPostmanFormatJson(List<CmdDes> cmdDesList, ApiType apiType) throws JsonProcessingException {
            boolean restful = apiType.equals((Object)ApiType.RESTFUL);
            boolean jsonrpc = apiType.equals((Object)ApiType.JSONRPC);
            PostmanFormat format = new PostmanFormat();
            Info info = new Info();
            format.setInfo(info);
            info.setName(appName + "-" + apiType.name());
            info.setSchema("https://schema.getpostman.com/json/collection/v2.1.0/collection.json");
            ArrayList<Item> item = new ArrayList<Item>();
            for (CmdDes des : cmdDesList) {
                Item aItem = new Item();
                aItem.setName(des.des + " - " + des.cmdName);
                Request request = new Request();
                Body body = new Body();
                Url url = new Url();
                request.setMethod(des.httpMethod);
                request.setBody(body);
                request.setDescription(des.md);
                if (jsonrpc) {
                    List nameList = des.getParameters().stream().map(p -> {
                        if (p.list == null) {
                            return p.name;
                        }
                        String formData = p.list.stream().map(pp -> pp.name).collect(Collectors.toList()).toString();
                        return formData.substring(1, formData.length() - 1);
                    }).collect(Collectors.toList());
                    body.setRaw(String.format("{\n\"jsonrpc\":\"2.0\",\n\"method\":\"%s\",\n\"params\":%s,\n\"id\":1234\n}\n", des.cmdName, nameList.toString()));
                    url = Url.jsonrpcInstance();
                } else if (restful) {
                    Optional<ResultDes> first = des.getParameters().stream().filter(p -> p.formJsonOfRestful != null).findFirst();
                    if (!first.isEmpty()) {
                        body.setRaw(first.get().formJsonOfRestful);
                    }
                    url.path.add(des.cmdName.substring(1));
                    url.raw = String.format("%s://%s:%s/%s", url.protocol, url.host.get(0), url.port, url.path.get(0));
                }
                request.setUrl(url);
                aItem.setRequest(request);
                item.add(aItem);
            }
            format.setItem(item);
            String formatStr = JSONUtils.obj2json((Object)format);
            return formatStr;
        }

        private static class Url {
            private String raw;
            private String protocol = "https";
            private List<String> host = new ArrayList<String>();
            private String port;
            private List<String> path;

            public Url() {
                this.host.add("api.nuls.io");
                this.port = null;
                this.path = new ArrayList<String>();
            }

            public static Url jsonrpcInstance() {
                Url url = new Url();
                url.path.add("jsonrpc");
                url.raw = "https://api.nuls.io/jsonrpc";
                return url;
            }

            public String getRaw() {
                return this.raw;
            }

            public void setRaw(String raw) {
                this.raw = raw;
            }

            public String getProtocol() {
                return this.protocol;
            }

            public void setProtocol(String protocol) {
                this.protocol = protocol;
            }

            public List<String> getHost() {
                return this.host;
            }

            public void setHost(List<String> host) {
                this.host = host;
            }

            public String getPort() {
                return this.port;
            }

            public void setPort(String port) {
                this.port = port;
            }

            public List<String> getPath() {
                return this.path;
            }

            public void setPath(List<String> path) {
                this.path = path;
            }
        }

        private static class Body {
            private String mode = "raw";
            private String raw;

            public String getMode() {
                return this.mode;
            }

            public void setMode(String mode) {
                this.mode = mode;
            }

            public String getRaw() {
                return this.raw;
            }

            public void setRaw(String raw) {
                this.raw = raw;
            }
        }

        private static class Header {
            private String key;
            private String name;
            private String value;
            private String type;

            private Header() {
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }
        }

        private static class Request {
            private String method;
            private List<Header> header = new ArrayList<Header>();
            private Body body;
            private Url url;
            private String description;

            public Request() {
                Header header = new Header();
                header.setKey("Content-Type");
                header.setName("Content-Type");
                header.setValue("application/json;charset=UTF-8");
                header.setType("text");
                this.header.add(header);
            }

            public String getMethod() {
                return this.method;
            }

            public void setMethod(String method) {
                this.method = method;
            }

            public List<Header> getHeader() {
                return this.header;
            }

            public void setHeader(List<Header> header) {
                this.header = header;
            }

            public Body getBody() {
                return this.body;
            }

            public void setBody(Body body) {
                this.body = body;
            }

            public Url getUrl() {
                return this.url;
            }

            public void setUrl(Url url) {
                this.url = url;
            }

            public String getDescription() {
                return this.description;
            }

            public void setDescription(String description) {
                this.description = description;
            }
        }

        private static class Item {
            private String name;
            private Request request;
            private List<String> response = new ArrayList<String>();

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public Request getRequest() {
                return this.request;
            }

            public void setRequest(Request request) {
                this.request = request;
            }

            public List<String> getResponse() {
                return this.response;
            }

            public void setResponse(List<String> response) {
                this.response = response;
            }
        }

        private static class Info {
            private String _postman_id = UUID.randomUUID().toString();
            private String name;
            private String schema;

            public String get_postman_id() {
                return this._postman_id;
            }

            public void set_postman_id(String _postman_id) {
                this._postman_id = _postman_id;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getSchema() {
                return this.schema;
            }

            public void setSchema(String schema) {
                this.schema = schema;
            }
        }

        private static class PostmanFormat {
            private Info info;
            private List<Item> item;

            private PostmanFormat() {
            }

            public Info getInfo() {
                return this.info;
            }

            public void setInfo(Info info) {
                this.info = info;
            }

            public List<Item> getItem() {
                return this.item;
            }

            public void setItem(List<Item> item) {
                this.item = item;
            }
        }
    }

    public static class CmdDes
    implements Serializable {
        int order;
        String cmdName;
        String cmdType;
        String des;
        String detailDesc;
        String httpMethod;
        String md;
        List<ResultDes> parameters;
        List<ResultDes> result;

        public String getMd() {
            return this.md;
        }

        public void setMd(String md) {
            this.md = md;
        }

        public String getCmdName() {
            return this.cmdName;
        }

        public void setCmdName(String cmdName) {
            this.cmdName = cmdName;
        }

        public String getCmdType() {
            return this.cmdType;
        }

        public void setCmdType(String cmdType) {
            this.cmdType = cmdType;
        }

        public String getDes() {
            return this.des;
        }

        public void setDes(String des) {
            this.des = des;
        }

        public String getDetailDesc() {
            return this.detailDesc;
        }

        public void setDetailDesc(String detailDesc) {
            this.detailDesc = detailDesc;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public List<ResultDes> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<ResultDes> parameters) {
            this.parameters = parameters;
        }

        public List<ResultDes> getResult() {
            return this.result;
        }

        public void setResult(List<ResultDes> result) {
            this.result = result;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public int compareTo(int thatOrder) {
            if (this.order > thatOrder) {
                return 1;
            }
            if (this.order < thatOrder) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            sb.append("\"order\":").append(this.order);
            sb.append(",\"cmdName\":").append('\"').append(this.cmdName).append('\"');
            sb.append(",\"des\":").append('\"').append(this.des).append('\"');
            sb.append('}');
            return sb.toString();
        }
    }

    public static class ResultDes
    implements Serializable {
        String name;
        String des;
        String type;
        List<ResultDes> list;
        boolean canNull;
        String formJsonOfRestful;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDes() {
            return this.des;
        }

        public void setDes(String des) {
            this.des = des;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<ResultDes> getList() {
            return this.list;
        }

        public void setList(List<ResultDes> list) {
            this.list = list;
        }

        public boolean isCanNull() {
            return this.canNull;
        }

        public void setCanNull(boolean canNull) {
            this.canNull = canNull;
        }

        public String getFormJsonOfRestful() {
            return this.formJsonOfRestful;
        }

        public void setFormJsonOfRestful(String formJsonOfRestful) {
            this.formJsonOfRestful = formJsonOfRestful;
        }
    }
}

