/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.utils;

import io.nuls.core.log.logback.LoggerBuilder;
import io.nuls.core.log.logback.NulsLogger;
import java.util.HashMap;
import java.util.Map;

public class Log {
    public static NulsLogger DEFAULT_BASIC_LOGGER;
    private static ThreadLocal<Integer> currentThreadChainId;
    public static Map<Integer, NulsLogger> BASIC_LOGGER_MAP;

    private Log() {
    }

    public static void debug(String msg) {
        Log.getBasicLogger().debug(Log.wrapperLogContent(msg));
    }

    public static void debug(String msg, Object ... objs) {
        Log.getBasicLogger().debug(Log.wrapperLogContent(msg), objs);
    }

    public static void debug(String msg, Throwable throwable) {
        Log.getBasicLogger().debug(Log.wrapperLogContent(msg), throwable);
    }

    public static boolean isTraceEnabled() {
        return Log.getBasicLogger().getLogger().isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return Log.getBasicLogger().getLogger().isDebugEnabled();
    }

    public static boolean isInfoEnabled() {
        return Log.getBasicLogger().getLogger().isInfoEnabled();
    }

    public static boolean isWarnEnabled() {
        return Log.getBasicLogger().getLogger().isWarnEnabled();
    }

    public static boolean isErrorEnabled() {
        return Log.getBasicLogger().getLogger().isErrorEnabled();
    }

    public static void info(String msg) {
        Log.getBasicLogger().info(Log.wrapperLogContent(msg));
    }

    public static void info(String msg, Object ... objs) {
        Log.getBasicLogger().info(Log.wrapperLogContent(msg), objs);
    }

    public static void info(String msg, Throwable throwable) {
        Log.getBasicLogger().info(Log.wrapperLogContent(msg), throwable);
    }

    public static void warn(String msg) {
        Log.getBasicLogger().warn(Log.wrapperLogContent(msg));
    }

    public static void warn(String msg, Object ... objs) {
        Log.getBasicLogger().warn(Log.wrapperLogContent(msg), objs);
    }

    public static void warn(String msg, Throwable throwable) {
        Log.getBasicLogger().warn(Log.wrapperLogContent(msg), throwable);
    }

    public static void error(String msg) {
        Log.getBasicLogger().error(Log.wrapperLogContent(msg));
    }

    public static void error(String msg, Object ... objs) {
        Log.getBasicLogger().error(Log.wrapperLogContent(msg), objs);
    }

    public static void error(String msg, Throwable throwable) {
        Log.getBasicLogger().error(Log.wrapperLogContent(msg), throwable);
    }

    public static void error(Throwable throwable) {
        Log.getBasicLogger().error(throwable);
    }

    public static void trace(String msg) {
        Log.getBasicLogger().trace(Log.wrapperLogContent(msg));
    }

    public static void trace(String msg, Throwable throwable) {
        Log.getBasicLogger().trace(Log.wrapperLogContent(msg), throwable);
    }

    private static String wrapperLogContent(String msg) {
        return msg;
    }

    public static void currentThreadChainId(Integer chainId) {
        currentThreadChainId.set(chainId);
    }

    private static NulsLogger getBasicLogger() {
        Integer chainId = currentThreadChainId.get();
        if (chainId != null) {
            NulsLogger nulsLogger = BASIC_LOGGER_MAP.get(chainId);
            if (nulsLogger != null) {
                return nulsLogger;
            }
            return Log.getDefaultBasicLogger();
        }
        return Log.getDefaultBasicLogger();
    }

    private static NulsLogger getDefaultBasicLogger() {
        if (DEFAULT_BASIC_LOGGER == null) {
            DEFAULT_BASIC_LOGGER = LoggerBuilder.getLogger((String)"sdk-provider");
            DEFAULT_BASIC_LOGGER.addBasicPath(Log.class.getName());
        }
        return DEFAULT_BASIC_LOGGER;
    }

    static {
        currentThreadChainId = new ThreadLocal();
        BASIC_LOGGER_MAP = new HashMap<Integer, NulsLogger>(4);
    }
}

