/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client;

import com.fasterxml.jackson.core.JsonParser;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.ParameterException;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.account.BackupAccountProcessor;
import io.nuls.cmd.client.processor.account.CreateMultiAccountProcessor;
import io.nuls.cmd.client.processor.account.CreateProcessor;
import io.nuls.cmd.client.processor.account.GetAccountProcessor;
import io.nuls.cmd.client.processor.account.GetAccountsProcessor;
import io.nuls.cmd.client.processor.account.GetMultiSignAccountProcessor;
import io.nuls.cmd.client.processor.account.GetPrivateKeyProcessor;
import io.nuls.cmd.client.processor.account.ImportByKeyStoreProcessor;
import io.nuls.cmd.client.processor.account.ImportByPrivateKeyProcessor;
import io.nuls.cmd.client.processor.account.ImportKeyStoreFilesProcessor;
import io.nuls.cmd.client.processor.account.RemoveAccountProcessor;
import io.nuls.cmd.client.processor.account.RemoveMultiSignAccountProcessor;
import io.nuls.cmd.client.processor.account.SetAliasProcessor;
import io.nuls.cmd.client.processor.account.SetMultiSignAliasProcessor;
import io.nuls.cmd.client.processor.account.UpdatePasswordProcessor;
import io.nuls.cmd.client.processor.block.GetBestBlockHeaderProcessor;
import io.nuls.cmd.client.processor.block.GetBlockHeaderProcessor;
import io.nuls.cmd.client.processor.block.RollbackProcessor;
import io.nuls.cmd.client.processor.consensus.CreateAgentProcessor;
import io.nuls.cmd.client.processor.consensus.CreateMultiSignAgentProcessor;
import io.nuls.cmd.client.processor.consensus.DepositForMultiSignProcessor;
import io.nuls.cmd.client.processor.consensus.DepositProcessor;
import io.nuls.cmd.client.processor.consensus.GetAgentInfoProcessor;
import io.nuls.cmd.client.processor.consensus.GetAgentsProcessor;
import io.nuls.cmd.client.processor.consensus.StopAgentProcessor;
import io.nuls.cmd.client.processor.consensus.StopMultiSignAgentProcessor;
import io.nuls.cmd.client.processor.consensus.WithdrawForMultiSignProcessor;
import io.nuls.cmd.client.processor.consensus.WithdrawProcessor;
import io.nuls.cmd.client.processor.contract.CallContractProcessor;
import io.nuls.cmd.client.processor.contract.CreateContractProcessor;
import io.nuls.cmd.client.processor.contract.DeleteContractProcessor;
import io.nuls.cmd.client.processor.contract.GetAccountContractListProcessor;
import io.nuls.cmd.client.processor.contract.GetContractConstructorProcessor;
import io.nuls.cmd.client.processor.contract.GetContractInfoProcessor;
import io.nuls.cmd.client.processor.contract.GetContractResultProcessor;
import io.nuls.cmd.client.processor.contract.GetContractTxProcessor;
import io.nuls.cmd.client.processor.contract.TokenTransferProcessor;
import io.nuls.cmd.client.processor.contract.TransferToContractProcessor;
import io.nuls.cmd.client.processor.contract.ViewContractProcessor;
import io.nuls.cmd.client.processor.crosschain.CreateCrossTxProcessor;
import io.nuls.cmd.client.processor.crosschain.CrossAssetAddProcessor;
import io.nuls.cmd.client.processor.crosschain.CrossAssetDisableProcessor;
import io.nuls.cmd.client.processor.crosschain.CrossLocalAssetAddProcessor;
import io.nuls.cmd.client.processor.crosschain.GetCrossAssetInfoProcessor;
import io.nuls.cmd.client.processor.crosschain.GetCrossChainRegisterInfoProcessor;
import io.nuls.cmd.client.processor.crosschain.GetCrossChainsSimpleInfoProcessor;
import io.nuls.cmd.client.processor.crosschain.GetCrossTxStateProcessor;
import io.nuls.cmd.client.processor.crosschain.RegisterCrossChainProcessor;
import io.nuls.cmd.client.processor.crosschain.RehandleCrossTxProcessor;
import io.nuls.cmd.client.processor.crosschain.ResetLocalVerifierTxProcessor;
import io.nuls.cmd.client.processor.crosschain.UpdateCrossChainProcessor;
import io.nuls.cmd.client.processor.ledger.GetBalanceProcessor;
import io.nuls.cmd.client.processor.ledger.GetContractCrossAssetProcessor;
import io.nuls.cmd.client.processor.ledger.GetLocalCrossAssetProcessor;
import io.nuls.cmd.client.processor.ledger.RegisterLocalAssetProcessor;
import io.nuls.cmd.client.processor.network.GetNetworkProcessor;
import io.nuls.cmd.client.processor.system.ExitProcessor;
import io.nuls.cmd.client.processor.system.HelpProcessor;
import io.nuls.cmd.client.processor.system.VersionProcessor;
import io.nuls.cmd.client.processor.transaction.CreateMultiSignTransferAndSignProcessor;
import io.nuls.cmd.client.processor.transaction.CreateMultiSignTransferProcessor;
import io.nuls.cmd.client.processor.transaction.GetTxProcessor;
import io.nuls.cmd.client.processor.transaction.SignMultiSingTransferProcessor;
import io.nuls.cmd.client.processor.transaction.TransferProcessor;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.ConsoleReader;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;

@Component
public class CommandHandler
implements InitializingBean {
    public static final Map<String, CommandProcessor> PROCESSOR_MAP = new TreeMap<String, CommandProcessor>();
    public static ConsoleReader CONSOLE_READER;
    private static final Pattern CMD_PATTERN;

    public void afterPropertiesSet() throws NulsException {
        this.register((CommandProcessor)SpringLiteContext.getBean(CreateProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(BackupAccountProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(ImportByKeyStoreProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(ImportByPrivateKeyProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(ImportKeyStoreFilesProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(UpdatePasswordProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetAccountProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetAccountsProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(RemoveAccountProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetPrivateKeyProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(SetAliasProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(TransferProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetBestBlockHeaderProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetBlockHeaderProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(RollbackProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetTxProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetBalanceProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(RegisterLocalAssetProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetContractCrossAssetProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetLocalCrossAssetProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CreateAgentProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(StopAgentProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(DepositProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(WithdrawProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetAgentsProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetAgentInfoProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(ExitProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(HelpProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(VersionProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetNetworkProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CreateMultiAccountProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(RemoveMultiSignAccountProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CreateMultiSignTransferProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CreateMultiSignTransferAndSignProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(SignMultiSingTransferProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(SetMultiSignAliasProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetMultiSignAccountProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CreateMultiSignAgentProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(StopMultiSignAgentProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(DepositForMultiSignProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(WithdrawForMultiSignProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CreateContractProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CallContractProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(DeleteContractProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetContractConstructorProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetContractInfoProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetContractResultProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetContractTxProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(TokenTransferProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(TransferToContractProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(ViewContractProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetAccountContractListProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(RegisterCrossChainProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CrossAssetAddProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CrossAssetDisableProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(UpdateCrossChainProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CrossLocalAssetAddProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(RehandleCrossTxProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(CreateCrossTxProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetCrossChainsSimpleInfoProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetCrossChainRegisterInfoProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetCrossAssetInfoProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(GetCrossTxStateProcessor.class));
        this.register((CommandProcessor)SpringLiteContext.getBean(ResetLocalVerifierTxProcessor.class));
        JSONUtils.getInstance().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public void start() {
        if (System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1) {
            System.setProperty("jline.WindowsTerminal.directConsole", "false");
        }
        try {
            String line;
            CONSOLE_READER = new ConsoleReader();
            ArrayList<StringsCompleter> completers = new ArrayList<StringsCompleter>();
            completers.add(new StringsCompleter(PROCESSOR_MAP.keySet()));
            CONSOLE_READER.addCompleter((Completer)new ArgumentCompleter(completers));
            do {
                if (StringUtils.isBlank((String)(line = CONSOLE_READER.readLine("nuls>>> ")))) continue;
                this.processCommand(line);
            } while (line != null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (!CONSOLE_READER.delete()) {
                    CONSOLE_READER.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String[] parseArgs(String line) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)line)) {
            return new String[0];
        }
        Matcher matcher = CMD_PATTERN.matcher(line);
        String result = line;
        while (matcher.find()) {
            String group = matcher.group();
            String subGroup = group.substring(1, group.length() - 1);
            String encoder = URLEncoder.encode(subGroup, StandardCharsets.UTF_8.toString());
            result = result.replace(group, encoder);
        }
        String[] args = result.split("\\s+");
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            args[i] = URLDecoder.decode(args[i], StandardCharsets.UTF_8.toString());
        }
        return args;
    }

    public void processCommand(String args) throws UnsupportedEncodingException {
        String[] cmdArgs = CommandHandler.parseArgs(args);
        try {
            CommandResult commandResult = this.processCommand(cmdArgs);
            System.out.print(commandResult.toString() + "\n");
        }
        catch (Exception e) {
            if (System.Logger.Level.DEBUG.getName().equals(System.getProperty("log.level"))) {
                e.printStackTrace();
            }
            System.out.println("Exception: " + e.getMessage());
        }
    }

    public CommandResult processCommand(String[] args) {
        int length = args.length;
        if (length == 0) {
            return CommandResult.getFailed("command error! ");
        }
        String command = args[0].trim();
        CommandProcessor processor = PROCESSOR_MAP.get(command);
        if (processor == null) {
            return CommandResult.getFailed(command + " not a nuls command!");
        }
        if (length == 2 && "-h".equals(args[1])) {
            return CommandResult.getFailed(processor.getHelp());
        }
        try {
            boolean result = processor.argsValidate(args);
            if (!result) {
                return CommandResult.getFailed("args incorrect:\n" + processor.getHelp());
            }
        }
        catch (ParameterException e) {
            return CommandResult.getFailed(e.getMessage() + "\nargs incorrect:\n" + processor.getHelp());
        }
        return processor.execute(args);
    }

    private void register(CommandProcessor processor) {
        PROCESSOR_MAP.put(processor.getCommand(), processor);
    }

    public boolean hasCommand(String command) {
        return PROCESSOR_MAP.containsKey(command);
    }

    static {
        CMD_PATTERN = Pattern.compile("\"[^\"]+\"|'[^']+'");
    }
}

