/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.nuls.base.api.provider.Result;
import io.nuls.cmd.client.processor.ErrorCodeConstants;
import io.nuls.cmd.client.utils.LoggerUtil;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import java.util.Map;

public class CommandResult {
    public boolean success;
    private String message;
    static NulsLogger log = LoggerUtil.logger;

    public boolean isSuccess() {
        return this.success;
    }

    public CommandResult setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommandResult setMessage(String message) {
        this.message = message;
        return this;
    }

    public String toString() {
        if (StringUtils.isBlank((String)this.message)) {
            return "result:" + this.success;
        }
        return this.message;
    }

    public static CommandResult failed(String errCode) {
        return CommandResult.getFailed(ErrorCodeConstants.SYSTEM_ERR.getMsg());
    }

    public static CommandResult getFailed(String message) {
        CommandResult result = new CommandResult();
        result.setMessage(message);
        result.setSuccess(false);
        return result;
    }

    public static CommandResult getFailed(Result rpcResult) {
        CommandResult result = new CommandResult();
        result.setMessage(rpcResult.getMessage());
        result.setSuccess(false);
        return result;
    }

    public static CommandResult getResult(Result rpcResult) {
        if (null == rpcResult) {
            return CommandResult.getFailed("Result is null!");
        }
        CommandResult result = new CommandResult();
        result.setSuccess(rpcResult.isSuccess());
        Object message = "";
        if (!rpcResult.isSuccess()) {
            Map map = (Map)rpcResult.getData();
            message = (String)map.get("msg");
        } else {
            try {
                message = rpcResult.getData() != null ? (String)message + JSONUtils.obj2PrettyJson((Object)rpcResult.getData()) : (rpcResult.getList() != null ? (String)message + JSONUtils.obj2PrettyJson((Object)rpcResult.getList()) : (String)message + "success");
            }
            catch (Exception e) {
                log.error("return data format exception :", e);
            }
        }
        result.setMessage((String)message);
        return result;
    }

    public static CommandResult getSuccess(String message) {
        return new CommandResult().setSuccess(true).setMessage(message);
    }

    public static CommandResult getSuccess(Result rpcResult) {
        try {
            return new CommandResult().setSuccess(true).setMessage(JSONUtils.obj2PrettyJson((Object)rpcResult.getData()));
        }
        catch (JsonProcessingException e) {
            log.error("", (Exception)((Object)e));
            return null;
        }
    }

    public static Result dataTransformValue(Result rpcResult) {
        Map map = (Map)rpcResult.getData();
        if (null != map) {
            rpcResult.setData(map.get("value"));
        }
        return rpcResult;
    }

    public static Result dataMultiTransformValue(Result rpcResult) {
        Map map = (Map)rpcResult.getData();
        if (null != map) {
            rpcResult.setData(map.get("txData"));
        }
        return rpcResult;
    }

    public static Result dataTransformList(Result rpcResult) {
        rpcResult.setData((Object)rpcResult.getList());
        return rpcResult;
    }
}

