/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Address;
import io.nuls.cmd.client.config.Config;
import io.nuls.core.constant.BaseConstant;
import io.nuls.core.core.ioc.SpringLiteContext;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.parse.SerializeUtils;

public class Tools {
    public static void main(String[] args) {
        String cmd;
        if (args.length < 1) {
            System.out.println("cmd must be null");
            System.exit(0);
        }
        SpringLiteContext.init((String[])new String[]{"io.nuls.cmd.client.config"});
        Config config = (Config)SpringLiteContext.getBean(Config.class);
        switch (cmd = args[0]) {
            case "address": {
                int count = 1;
                int chainId = config.getChainId();
                if (args.length >= 3) {
                    chainId = Integer.parseInt(args[2]);
                }
                if (args.length >= 2) {
                    count = Integer.parseInt(args[1]);
                }
                System.out.println("chainId:" + chainId);
                System.out.println("number:" + count);
                String addressPrefix = "";
                addressPrefix = chainId == 1 || chainId == 2 ? config.getAddressPrefix() : config.getAddressPrefix().toUpperCase();
                for (int i = 0; i < count; ++i) {
                    ECKey key = new ECKey();
                    Address address = new Address(chainId, addressPrefix, BaseConstant.DEFAULT_ADDRESS_TYPE, SerializeUtils.sha256hash160((byte[])key.getPubKey()));
                    System.out.println("=".repeat(100));
                    System.out.println("address   :" + AddressTool.getStringAddressByBytes((byte[])address.getAddressBytes(), (String)address.getPrefix()));
                    System.out.println("privateKey:" + key.getPrivateKeyAsHex());
                    System.out.println("=".repeat(100));
                }
                System.exit(0);
            }
        }
        System.out.println("error command :" + args[0]);
        System.exit(0);
    }
}

