/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.account;

import io.nuls.base.api.provider.Result;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.account.AccountBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class GetAccountsProcessor
extends AccountBaseProcessor
implements CommandProcessor {
    @Override
    public String getCommand() {
        return "getaccounts";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription());
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getaccounts --get all account info list int the wallet";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 0);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result = this.accountService.getAccountList();
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(CommandResult.dataTransformList(result));
    }
}

