/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.account;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.account.facade.RemoveMultiSignAccountReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.account.AccountBaseProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;

@Component
public class RemoveMultiSignAccountProcessor
extends AccountBaseProcessor
implements CommandProcessor {
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "removemultisignaccount";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address> The multi sign account address - Required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "removemultisignaccount <address> --remove an multi sign account";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkAddress(this.config.getChainId(), args[1]);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        Result result = this.accountService.removeMultiSignAccount(new RemoveMultiSignAccountReq(address));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess("Success");
    }
}

