/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.block;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.block.BlockService;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByLastHeightReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class GetBestBlockHeaderProcessor
implements CommandProcessor {
    BlockService blockService = (BlockService)ServiceManager.get(BlockService.class);

    @Override
    public String getCommand() {
        return "getlatestblockheader";
    }

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.Block;
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription());
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getlatestblockheader --get the best block header";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 0);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result = this.blockService.getBlockHeaderByLastHeight(new GetBlockHeaderByLastHeightReq());
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

