/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.consensus;

import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.consensus.ConsensusProvider;
import io.nuls.base.api.provider.consensus.facade.AgentInfo;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.parse.MapUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.math.BigInteger;
import java.util.Map;

public abstract class ConsensusBaseProcessor
implements CommandProcessor {
    @Autowired
    Config config;
    ConsensusProvider consensusProvider = (ConsensusProvider)ServiceManager.get(ConsensusProvider.class);

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.Consensus;
    }

    public Map<String, Object> agentToMap(AgentInfo info) {
        Map map = MapUtils.beanToMap((Object)info);
        map.put("deposit", this.config.toBigUnit(new BigInteger(info.getDeposit())));
        map.put("totalDeposit", this.config.toBigUnit(new BigInteger(info.getTotalDeposit())));
        map.put("time", NulsDateUtils.timeStamp2DateStr((long)(info.getTime() * 1000L)));
        map.put("status", CommandHelper.consensusExplain((Integer)map.get("status")));
        return map;
    }
}

