/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.consensus;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.consensus.ConsensusProvider;
import io.nuls.base.api.provider.consensus.facade.MultiSignAccountDepositToAgentReq;
import io.nuls.base.data.NulsHash;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.consensus.ConsensusBaseProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import java.math.BigInteger;

@Component
public class DepositForMultiSignProcessor
extends ConsensusBaseProcessor
implements CommandProcessor {
    ConsensusProvider consensusProvider = (ConsensusProvider)ServiceManager.get(ConsensusProvider.class);
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "depositformultisign";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<address>   Your own account address -required").newLine("\t<agentHash>   The agent hash you want to deposit  -required").newLine("\t<deposit>   the amount you want to deposit, you can have up to 8 valid digits after the decimal point -required").newLine("\t[sign address] first sign address -- not required");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "depositformultisign <address> <agentHash> <deposit> [sign address] --apply for deposit";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 3, 4);
        this.checkAddress(this.config.getChainId(), args[1]);
        this.checkIsNumeric(args[3], "deposit");
        this.checkArgs(NulsHash.validHash((String)args[2]), "agentHash format error");
        if (args.length == 5) {
            this.checkAddress(this.config.getChainId(), args[4]);
        }
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result;
        String address = args[1];
        BigInteger deposit = this.config.toSmallUnit(args[3]);
        String agentHash = args[2];
        MultiSignAccountDepositToAgentReq req = new MultiSignAccountDepositToAgentReq(address, agentHash, deposit);
        if (args.length == 5) {
            String signAddress = args[4];
            String password = this.getPwd();
            req.setSignAddress(signAddress);
            req.setPassword(password);
        }
        if ((result = this.consensusProvider.depositToAgentForMultiSignAccount(req)).isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

