/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.consensus;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.consensus.ConsensusProvider;
import io.nuls.base.api.provider.consensus.facade.StopMultiSignAgentReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.consensus.ConsensusBaseProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;

@Component
public class StopMultiSignAgentProcessor
extends ConsensusBaseProcessor
implements CommandProcessor {
    @Autowired
    Config config;
    ConsensusProvider consensusProvider = (ConsensusProvider)ServiceManager.get(ConsensusProvider.class);

    @Override
    public String getCommand() {
        return "stopmultisignagent";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<address> account address of the agent -required").newLine("\t[sign address] first sign address for transfer -- not required");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "stopmultisignagent <address> [sign address]  -- stop the multi sign agent";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1, 2);
        this.checkAddress(this.config.getChainId(), args[1]);
        if (args.length == 3) {
            this.checkAddress(this.config.getChainId(), args[2]);
        }
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result;
        String address = args[1];
        StopMultiSignAgentReq req = new StopMultiSignAgentReq(address);
        if (args.length == 3) {
            String signAddress = args[2];
            String password = this.getPwd();
            req.setSignAddress(signAddress);
            req.setPassword(password);
        }
        if ((result = this.consensusProvider.stopAgentForMultiSignAccount(req)).isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

