/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.consensus;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.consensus.ConsensusProvider;
import io.nuls.base.api.provider.consensus.facade.MultiSignAccountWithdrawReq;
import io.nuls.base.data.NulsHash;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.consensus.ConsensusBaseProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;

@Component
public class WithdrawForMultiSignProcessor
extends ConsensusBaseProcessor
implements CommandProcessor {
    @Autowired
    Config config;
    ConsensusProvider consensusProvider = (ConsensusProvider)ServiceManager.get(ConsensusProvider.class);

    @Override
    public String getCommand() {
        return "withdrawformultisign";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<address>   address -required").newLine("\t<txHash>    your deposit transaction hash  -required").newLine("\t[sign address] first sign address -- not required");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "withdrawformultisign <address> <txHash> [sign address]-- withdraw the agent";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 2, 3);
        this.checkAddress(this.config.getChainId(), args[1]);
        this.checkArgs(NulsHash.validHash((String)args[2]), "txHash format error");
        if (args.length == 4) {
            this.checkAddress(this.config.getChainId(), args[3]);
        }
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result;
        String address = args[1];
        String txHash = args[2];
        MultiSignAccountWithdrawReq req = new MultiSignAccountWithdrawReq(address, txHash);
        if (args.length == 4) {
            String signAddress = args[3];
            String password = this.getPwd();
            req.setSignAddress(signAddress);
            req.setPassword(password);
        }
        if ((result = this.consensusProvider.withdrawForMultiSignAccount(req)).isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

